/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics;

import com.oceanoptics.joedriver.hr4000.HR4000;
import com.oceanoptics.joedriver.hr4000.HR4000Status;

public class HR4000Trial {
    HR4000 hr = new HR4000();

    public HR4000Trial() {
        this.init();
        System.out.println("");
        System.out.println("end.");
    }

    public void init() {
        System.out.println("OP_INIT");
        System.out.println("Device ID: " + this.hr.openSpectrometer(0));
        System.out.println("");
    }

    public void testITime() {
        System.out.println("OP_ITIME");
        int iTime = 10;
        System.out.println("Setting Integration time to " + iTime + "...");
        this.hr.setIntegrationTime(iTime);
        System.out.println("");
    }

    public void testLED() {
        System.out.println("OP_LED");
        System.out.println("Turning off strobe..");
        this.hr.setStrobeEnable(true);
        System.out.println("");
    }

    public void testPowerDown() {
        System.out.println("OP_POWERDOWN");
        System.out.println("Power up/down??");
        System.out.println("Shutting down the HR4000...");
        this.hr.setPowerDown(false);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void testGetInfo() {
    }

    public void testPutInfo() {
    }

    public void testSetTrigMode() {
        System.out.println("OP_SETTRIGMODE");
        System.out.println("Setting Trigger Mode to 1...");
        this.hr.setExternalTriggerMode(1);
        System.out.println("");
    }

    public void testCountPlugin() {
        System.out.println("OP_PLUGINCOUNT");
        System.out.println("Counting Plugins...");
        System.out.println("Number of plugins :" + this.hr.getNumPlugIns());
        System.out.println("");
    }

    public void testQueryPlugin() {
        System.out.println("OP_PLUGIN");
        System.out.println("Querying plugins...");
        byte[] j = this.hr.getPlugIns();
        for (int i = 0; i < j.length; ++i) {
            System.out.println("Value at I2C address " + (i + 2) + ": " + j[i]);
        }
        System.out.println("");
    }

    public void testI2CRead() {
        System.out.println("OP_I2CREAD");
        System.out.println("Reading I2C...");
        int numBytes = 60;
        for (int address = 0; address < 10; ++address) {
            byte[] k = this.hr.getI2C((byte)address, (byte)numBytes);
            for (int i = 0; i < numBytes; ++i) {
                System.out.println("Values at I2C address " + address + ": " + k[i]);
            }
            System.out.println("");
        }
    }

    public void testI2CWrite() {
        System.out.println("OP_I2CWRITE");
        System.out.println("Writing to the I2C 0...");
        byte[] z = new byte[]{5};
        System.out.println("I2C Write result: " + this.hr.setI2C((byte)0, (byte)1, z));
        System.out.println("");
    }

    public void testSPIRead() {
        System.out.println("OP_SPIREAD");
        System.out.println("SPI read");
        byte[] b = this.hr.getSPI(5);
        for (int i = 0; i < b.length; ++i) {
            System.out.println(b[i]);
        }
        System.out.println("");
    }

    public void testSPIWrite() {
        System.out.println("OP_SPIWRITE");
        byte[] c = new byte[]{1, 2, 3, 4, 5};
        System.out.println("SPI Write");
        this.hr.setSPI(5, c);
        System.out.println("");
    }

    public void testPSOC() {
        System.out.println("OP_PSOCREAD");
        String a = this.hr.getPSOCVersion();
        System.out.println("PSoC Firmware Version: " + a);
        System.out.println("");
        int data = 100;
        System.out.println("OP_PSOCWRITE");
        this.hr.setPSOC(data);
        System.out.println("");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int psoc = this.hr.getPSOC();
        System.out.println("PSoC ADC Value: " + psoc);
        System.out.println((double)psoc / 1637.4 + " volts");
        System.out.println("");
        data = 200;
        System.out.println("OP_PSOCWRITE");
        this.hr.setPSOC(data);
        System.out.println("");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        psoc = this.hr.getPSOC();
        System.out.println("PSoC ADC Value: " + psoc);
        System.out.println((double)psoc / 1637.4 + " volts");
        System.out.println("");
        data = 301;
        System.out.println("OP_PSOCWRITE");
        this.hr.setPSOC(data);
        System.out.println("");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        psoc = this.hr.getPSOC();
        System.out.println("PSoC ADC Value: " + psoc);
        System.out.println((double)psoc / 1637.4 + " volts");
        System.out.println("");
        data = 401;
        System.out.println("OP_PSOCWRITE");
        this.hr.setPSOC(data);
        System.out.println("");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        psoc = this.hr.getPSOC();
        System.out.println("PSoC ADC Value: " + psoc);
        System.out.println((double)psoc / 1637.4 + " volts");
        System.out.println("");
        data = 501;
        System.out.println("OP_PSOCWRITE");
        this.hr.setPSOC(data);
        System.out.println("");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        psoc = this.hr.getPSOC();
        System.out.println("PSoC ADC Value: " + psoc);
        System.out.println((double)psoc / 1637.4 + " volts");
        System.out.println("");
    }

    public void testFPGAWriteRead() {
        System.out.println("OP_FPGAWRITE");
        System.out.println("OP_FPGAREAD");
        System.out.println("Write to register, then read from register...");
        System.out.println("");
        byte x = 12;
        this.hr.setFPGA(x, 0);
        System.out.println("Strobe base clock set to 0");
        System.out.println("Strobe base clock: " + this.hr.getFPGA(x));
        System.out.println("");
    }

    public void testGetAllFPGA() {
        System.out.println("Get all FPGA");
        int[] s = this.hr.getAllFPGA();
        System.out.println("");
    }

    public void testReadTemp() {
        System.out.println("OP_READTEMP");
        System.out.println("Reading PCB temp...");
        System.out.println("PCB temp: " + this.hr.getBoardTemperature());
        System.out.println("");
    }

    public void testGetIRCal() {
        System.out.println("OP_GETIRCAL");
        System.out.println("Reading irradiance factors for address 0...");
    }

    public void testSetIRCal() {
        byte[] c = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        System.out.println("OP_SETIRCAL");
        System.out.println("");
    }

    public void testStatus() {
        System.out.println("OP_STATUS");
        System.out.println("Querying Status");
        HR4000Status hs = new HR4000Status();
        hs = this.hr.getStatus();
        System.out.println("");
        System.out.println("Number of Pixels: " + hs.numPixels);
        System.out.println("Integration Time: " + hs.integrationTime);
        System.out.println("Lamp Enable: " + hs.lampEnabled);
        System.out.println("Trigger Mode: " + hs.externalTriggerMode);
        System.out.println("Spectral Acquisition Status: " + hs.takingScan);
        System.out.println("Packets in Spectra: " + hs.spectralPackets);
        System.out.println("Power Down Flag: " + hs.powerDownFlag);
        System.out.println("Packet Count: " + hs.packetCount);
        System.out.println("USB Comm (Mbs): " + hs.usbSpeed);
        System.out.println("");
    }

    public void testRequestSpectra() {
        System.out.println("OP_REQUESTSPEC");
        System.out.println("Requesting Spectra...");
        this.hr.scan(1);
        double[] d = this.hr.getAccumulator();
        for (int i = 0; i < d.length; ++i) {
            System.out.println(i + ":  " + d[i]);
        }
        System.out.println(" ");
    }

    public static void main(String[] args) {
        HR4000Trial t = new HR4000Trial();
    }
}

