/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.joedriver.adc1000usb;

import com.oceanoptics.joedriver.adc1000usb.ADC1000USBCoefficients;
import com.oceanoptics.joedriver.spectrometer.Coefficients;
import com.oceanoptics.joedriver.spectrometer.Spectrometer;

public class ADC1000USB
extends Spectrometer {
    protected final byte OP_SETCHANNEL = (byte)11;
    protected final byte OP_CONTSTROBE = (byte)12;
    protected final byte OP_DACINIT = (byte)80;
    protected final byte OP_DACREAD = (byte)81;
    protected final byte OP_DACWRITE = (byte)82;
    boolean dacInitialized = false;
    boolean dacPresent = false;
    protected ADC1000USBCoefficients coefficients;

    public int openSpectrometer(int index) {
        this.numberOfPixels = 2048;
        this.numberOfDarkPixels = 24;
        this.rawData = new byte[this.numberOfPixels * 2 + 1];
        this.intData = new int[this.numberOfPixels * 2 + 1];
        this.OP_GETINFO = (byte)35;
        this.accumulator = new double[this.numberOfPixels];
        this.coefficients = new ADC1000USBCoefficients();
        this.deviceID = this.usb.openDevice(9303, 4100, index);
        if (this.deviceID <= 0) {
            this.deviceType = -1;
            return this.deviceType;
        }
        this.deviceType = 4100;
        if (this.deviceType != -1) {
            this.deviceIndex = index;
            this.initialize();
            this.requestSpectrum();
            this.readSpectrum(null);
            this.getFirmwareVersion();
            this.getCoefficients();
            this.setWavelengthCoefficients(0, this.coefficients.wLInterceptCh0, this.coefficients.wLFirstCh0, this.coefficients.wLSecondCh0, this.coefficients.wLThirdCh0);
            this.setWavelengthCoefficients(1, this.coefficients.wLInterceptCh1, this.coefficients.wLFirstCh1, this.coefficients.wLSecondCh1, this.coefficients.wLThirdCh1);
            this.setWavelengthCoefficients(2, this.coefficients.wLInterceptCh2, this.coefficients.wLFirstCh2, this.coefficients.wLSecondCh2, this.coefficients.wLThirdCh2);
            this.setWavelengthCoefficients(3, this.coefficients.wLInterceptCh3, this.coefficients.wLFirstCh3, this.coefficients.wLSecondCh3, this.coefficients.wLThirdCh3);
            this.setWavelengthCoefficients(4, this.coefficients.wLInterceptCh4, this.coefficients.wLFirstCh4, this.coefficients.wLSecondCh4, this.coefficients.wLThirdCh4);
            this.setWavelengthCoefficients(5, this.coefficients.wLInterceptCh5, this.coefficients.wLFirstCh5, this.coefficients.wLSecondCh5, this.coefficients.wLThirdCh5);
            this.setWavelengthCoefficients(6, this.coefficients.wLInterceptCh6, this.coefficients.wLFirstCh6, this.coefficients.wLSecondCh6, this.coefficients.wLThirdCh6);
            this.setWavelengthCoefficients(7, this.coefficients.wLInterceptCh7, this.coefficients.wLFirstCh7, this.coefficients.wLSecondCh7, this.coefficients.wLThirdCh7);
        }
        return this.deviceID;
    }

    public void readSpectrum(byte[] data) {
    }

    protected int formatData() {
        for (int i = 0; i < this.numberOfPixels; ++i) {
            int LSBPacket = i / 64;
            int MSBPacket = LSBPacket + 1;
            byte LSB = this.rawData[LSBPacket * 64 + i];
            byte MSB = this.rawData[MSBPacket * 64 + i];
            this.intData[i] = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, MSB, LSB);
        }
        if (this.rawData[this.numberOfPixels * 2] != 105) {
            System.out.println("Out of sync");
            return 0;
        }
        return 1;
    }

    public Coefficients getCoefficients() {
        String[] str = new String[this.coefficients.NUM_SLOTS + 1];
        for (int i = 0; i < this.coefficients.NUM_SLOTS; ++i) {
            str[i] = this.getInfo(i);
        }
        str[this.coefficients.NUM_SLOTS] = this.getInfo(this.coefficients.SCPLD_VERSION);
        this.coefficients.serialNumber = str[0];
        this.coefficients.channelsEnabled = (byte)Integer.parseInt(str[this.coefficients.S_CHANNELS_ENABLED]);
        this.coefficients.wLInterceptCh0 = Double.parseDouble(str[2]);
        this.coefficients.wLFirstCh0 = Double.parseDouble(str[3]);
        this.coefficients.wLSecondCh0 = Double.parseDouble(str[4]);
        this.coefficients.wLThirdCh0 = Double.parseDouble(str[5]);
        this.coefficients.wLInterceptCh1 = Double.parseDouble(str[6]);
        this.coefficients.wLFirstCh1 = Double.parseDouble(str[7]);
        this.coefficients.wLSecondCh1 = Double.parseDouble(str[8]);
        this.coefficients.wLThirdCh1 = Double.parseDouble(str[9]);
        this.coefficients.wLInterceptCh2 = Double.parseDouble(str[10]);
        this.coefficients.wLFirstCh2 = Double.parseDouble(str[11]);
        this.coefficients.wLSecondCh2 = Double.parseDouble(str[12]);
        this.coefficients.wLThirdCh2 = Double.parseDouble(str[13]);
        this.coefficients.wLInterceptCh3 = Double.parseDouble(str[14]);
        this.coefficients.wLFirstCh3 = Double.parseDouble(str[15]);
        this.coefficients.wLSecondCh3 = Double.parseDouble(str[16]);
        this.coefficients.wLThirdCh3 = Double.parseDouble(str[17]);
        this.coefficients.wLInterceptCh4 = Double.parseDouble(str[18]);
        this.coefficients.wLFirstCh4 = Double.parseDouble(str[19]);
        this.coefficients.wLSecondCh4 = Double.parseDouble(str[20]);
        this.coefficients.wLThirdCh4 = Double.parseDouble(str[21]);
        this.coefficients.wLInterceptCh5 = Double.parseDouble(str[22]);
        this.coefficients.wLFirstCh5 = Double.parseDouble(str[23]);
        this.coefficients.wLSecondCh5 = Double.parseDouble(str[24]);
        this.coefficients.wLThirdCh5 = Double.parseDouble(str[25]);
        this.coefficients.wLInterceptCh6 = Double.parseDouble(str[26]);
        this.coefficients.wLFirstCh6 = Double.parseDouble(str[27]);
        this.coefficients.wLSecondCh6 = Double.parseDouble(str[28]);
        this.coefficients.wLThirdCh6 = Double.parseDouble(str[29]);
        this.coefficients.wLInterceptCh7 = Double.parseDouble(str[30]);
        this.coefficients.wLFirstCh7 = Double.parseDouble(str[31]);
        this.coefficients.wLSecondCh7 = Double.parseDouble(str[32]);
        this.coefficients.wLThirdCh7 = Double.parseDouble(str[33]);
        this.coefficients.cPLDVersion = str[33 + 1];
        return this.coefficients;
    }

    public void saveCoefficients(ADC1000USBCoefficients coef) {
        String[] str = new String[coef.NUM_SLOTS + 1];
        str[0] = coef.serialNumber;
        str[coef.S_CHANNELS_ENABLED] = String.valueOf(coef.channelsEnabled);
        str[2] = String.valueOf(coef.wLInterceptCh0);
        str[3] = String.valueOf(coef.wLFirstCh0);
        str[4] = String.valueOf(coef.wLSecondCh0);
        str[5] = String.valueOf(coef.wLThirdCh0);
        str[6] = String.valueOf(coef.wLInterceptCh1);
        str[7] = String.valueOf(coef.wLFirstCh1);
        str[8] = String.valueOf(coef.wLSecondCh1);
        str[9] = String.valueOf(coef.wLThirdCh1);
        str[10] = String.valueOf(coef.wLInterceptCh2);
        str[11] = String.valueOf(coef.wLFirstCh2);
        str[12] = String.valueOf(coef.wLSecondCh2);
        str[13] = String.valueOf(coef.wLThirdCh2);
        str[14] = String.valueOf(coef.wLInterceptCh3);
        str[15] = String.valueOf(coef.wLFirstCh3);
        str[16] = String.valueOf(coef.wLSecondCh3);
        str[17] = String.valueOf(coef.wLThirdCh3);
        str[18] = String.valueOf(coef.wLInterceptCh4);
        str[19] = String.valueOf(coef.wLFirstCh4);
        str[20] = String.valueOf(coef.wLSecondCh4);
        str[21] = String.valueOf(coef.wLThirdCh4);
        str[22] = String.valueOf(coef.wLInterceptCh5);
        str[23] = String.valueOf(coef.wLFirstCh5);
        str[24] = String.valueOf(coef.wLSecondCh5);
        str[25] = String.valueOf(coef.wLThirdCh5);
        str[26] = String.valueOf(coef.wLInterceptCh6);
        str[27] = String.valueOf(coef.wLFirstCh6);
        str[28] = String.valueOf(coef.wLSecondCh6);
        str[29] = String.valueOf(coef.wLThirdCh6);
        str[30] = String.valueOf(coef.wLInterceptCh7);
        str[31] = String.valueOf(coef.wLFirstCh7);
        str[32] = String.valueOf(coef.wLSecondCh7);
        str[33] = String.valueOf(coef.wLThirdCh7);
        for (int i = 0; i < coef.NUM_SLOTS; ++i) {
            this.setInfo(i, str[i]);
        }
        this.setInfo(coef.SCPLD_VERSION, coef.cPLDVersion);
    }

    public int setChannel(int channel) {
        byte[] out = new byte[5];
        out[0] = 11;
        out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(channel));
        out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(channel));
        super.setData(0, out, 3);
        return 1;
    }

    public int setContinuousStrobeDelay(int delay) {
        byte[] out = new byte[5];
        out[0] = 11;
        out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(delay));
        out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(delay));
        super.setData(out, 3);
        return 1;
    }

    public void initDAC() {
        if (this.firmwareVersionNumber > this.makeVersion(1, 10, 0)) {
            this.out[0] = 80;
            super.setData(this.out, 1);
            this.dacInitialized = true;
            if (this.getDAC(0) > 240) {
                this.dacPresent = true;
            }
        } else {
            System.out.println("Cannot init the DAC. DAC may not be present.");
        }
    }

    public int getDAC(int channel) {
        int value = -1;
        if (this.dacInitialized) {
            if (channel >= 0 && channel <= 7) {
                this.out[0] = 81;
                this.out[1] = (byte)channel;
                super.setData(0, this.out, 2);
                super.getData(this.in, 3);
                value = this.byteRoutines.MAKEWORD(this.in[1], this.in[2]) ^ 0xF000;
            } else {
                System.out.println("Invalid Channel.");
            }
        } else {
            this.initDAC();
            this.getDAC(channel);
        }
        return value;
    }

    public void setDAC(int channel, int value) {
        if (this.dacPresent) {
            if (channel >= 0 && channel <= 7) {
                this.out[0] = 82;
                this.out[1] = (byte)channel;
                this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(value));
                this.out[3] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(value));
                super.setData(0, this.out, 4);
            } else {
                System.out.println("Invalid Channel.");
            }
        } else {
            System.out.println("Can not write to DAC. May not be initialized or is not present.");
        }
    }

    public int getNumberOfPixels() {
        return this.numberOfPixels;
    }
}

