/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.joedriver.hr2000;

import com.oceanoptics.joedriver.hr2000.HR2000Status;
import com.oceanoptics.joedriver.plugins.USBSpectrometerPlugIn;
import com.oceanoptics.joedriver.spectrometer.Coefficients;
import com.oceanoptics.joedriver.spectrometer.Spectrometer;

public class HR2000
extends Spectrometer {
    public USBSpectrometerPlugIn plugIn;

    public int openSpectrometer(int index) {
        System.out.println("Opening the HR2000");
        this.numberOfPixels = 2048;
        this.numberOfDarkPixels = 24;
        this.rawData = new byte[this.numberOfPixels * 2 + 1];
        this.intData = new int[this.numberOfPixels * 2 + 1];
        this.accumulator = new double[this.numberOfPixels];
        this.coefficients = new Coefficients();
        this.deviceID = this.usb.openDevice(9303, 4106, index);
        if (this.deviceID <= 0) {
            this.deviceType = -1;
            return this.deviceType;
        }
        this.deviceType = 4106;
        if (this.deviceType != -1) {
            this.deviceIndex = index;
            this.initialize();
            this.requestSpectrum();
            this.readSpectrum(null);
            this.getFirmwareVersion();
            this.getCoefficients();
            this.setWavelengthCoefficients(this.wLIntercept, this.wLFirst, this.wLSecond, this.wLThird);
            this.plugIn = new USBSpectrometerPlugIn(this);
        }
        return this.deviceID;
    }

    public void readSpectrum(byte[] data) {
    }

    public int formatData() {
        for (int i = 0; i < this.numberOfPixels; ++i) {
            int LSBPacket = i / 64;
            int MSBPacket = LSBPacket + 1;
            byte LSB = this.rawData[LSBPacket * 64 + i];
            byte MSB = this.rawData[MSBPacket * 64 + i];
            this.intData[i] = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, MSB, LSB);
        }
        if (this.rawData[this.numberOfPixels * 2] != 105) {
            System.out.println("Out of sync");
            return 0;
        }
        return 1;
    }

    public void stopSpectrum() {
        if (this.firmwareVersionNumber >= this.makeVersion(1, 10, 0)) {
            byte[] out = new byte[4];
            out[0] = 30;
            out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(0));
            out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(0));
            super.setData(out, 3);
        }
    }

    public HR2000Status getStatus() {
        if (this.firmwareVersionNumber < this.makeVersion(1, 10, 0)) {
            return null;
        }
        byte[] sb = this.readStatus();
        HR2000Status stat = new HR2000Status();
        stat.numPixels = this.byteRoutines.MAKEWORD(sb[0], sb[1]);
        stat.integrationTime = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, sb[2], sb[3]);
        stat.lampEnabled = sb[4] != 0;
        stat.externalTriggerMode = sb[5];
        stat.takingScan = sb[6] != 0;
        stat.timerSwap = sb[7];
        stat.dataReady = sb[8] != 0;
        stat.failed = sb[9] != 0;
        return stat;
    }

    public void getCoefficients() {
        this.coefficients = this.readCoefficients();
    }

    public int getNumberOfPixels() {
        return this.numberOfPixels;
    }
}

