/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.joedriver.spectrometer;

import com.oceanoptics.joedriver.events.JoeDriverEvent;
import com.oceanoptics.joedriver.plugins.USBSpectrometerPlugIn;
import com.oceanoptics.joedriver.spectrometer.Coefficients;
import com.oceanoptics.joedriver.spectrometer.USBSpectrometerInfo;
import com.oceanoptics.joedriver.usbinterface.USBInterface;
import com.oceanoptics.miscroutines.ByteRoutines;
import java.io.UnsupportedEncodingException;

public abstract class Spectrometer
extends JoeDriverEvent {
    protected final byte OP_INIT = 1;
    protected final byte OP_ITIME = (byte)2;
    protected final byte OP_STROBE = (byte)3;
    protected final byte OP_POWERDOWN = (byte)4;
    protected final byte OP_PUTSERIAL = (byte)7;
    protected final byte OP_GETSERIAL = (byte)8;
    protected final byte OP_REQUESTSPEC = (byte)9;
    protected final byte OP_SETTRIGMODE = (byte)10;
    protected final byte OP_IRTE = (byte)11;
    protected final byte OP_HIGHGAIN = (byte)12;
    protected final byte OP_FANON = (byte)13;
    protected final byte OP_PLUGINCOUNT = (byte)11;
    protected final byte OP_PLUGIN = (byte)12;
    protected final byte OP_PLUGINDETECT = (byte)13;
    protected final byte OP_STOPSPEC = (byte)30;
    protected final byte OP_STATUS = (byte)-2;
    protected final byte OP_I2CREAD = (byte)96;
    protected final byte OP_I2CWRITE = (byte)97;
    protected final byte OP_SPIREAD = (byte)98;
    protected final byte OP_SPIWRITE = (byte)99;
    protected final byte OP_FPGAWRITE = (byte)106;
    protected final byte OP_FPGAREAD = (byte)107;
    protected final byte OP_READTEMP = (byte)108;
    protected final byte OP_GETIR = (byte)109;
    protected final byte OP_SETIR = (byte)110;
    protected byte OP_GETINFO = (byte)5;
    protected byte OP_PUTINFO = (byte)6;
    protected byte OP_SETMCLK = (byte)14;
    protected byte OP_PSOCREAD = (byte)104;
    protected byte OP_PSOCWRITE = (byte)105;
    protected byte OP_FANENABLE = (byte)112;
    protected byte OP_TECENABLE = (byte)113;
    protected byte OP_TECREAD = (byte)114;
    protected byte OP_TECSETTEMP = (byte)115;
    public static final int DEV_USB2000 = 4098;
    public static final int DEV_ADC1000USB = 4100;
    public static final int DEV_SAS = 4102;
    public static final int DEV_HR2000 = 4106;
    public static final int DEV_NIR512 = 4108;
    public static final int DEV_NIR256 = 4112;
    public static final int DEV_HR4000 = 4114;
    public static final int DEV_USB650 = 4116;
    public static final int DEV_HR2000PLUS = 4118;
    public static final int DEV_QE65000 = 4120;
    public static final int DEV_NOADC = 65280;
    public static final int DEV_NOT_FOUND = -1;
    public static final int[] DEVICE_TYPES = new int[]{4098, 4100, 4102, 4106, 4108, 4112, 4114, 4116, 4118, 4120};
    protected final int PIPE_OUT = 0;
    protected final int PIPE_SPECTRUM_1 = 1;
    protected final int PIPE_SPECTRUM_2 = 2;
    protected final int PIPE_IN = 3;
    protected final byte FPGA_MASTER_CLOCK = 0;
    protected final byte FPGA_FIRMWARE = (byte)4;
    protected final byte FPGA_CSTROBE_INT = (byte)8;
    protected final byte FPGA_CSTROBE_CLOCK = (byte)12;
    protected final byte FPGA_INT_BASE_CLOCK = (byte)16;
    protected final byte FPGA_INT_CLOCK = (byte)24;
    protected final byte FPGA_SHUTTER_CLOCK = (byte)32;
    protected final byte FPGA_HARDWARE_TRIG_DELAY = (byte)40;
    protected final byte FPGA_HARDWARE_TRIG_MODE = (byte)44;
    protected final byte FPGA_INTERRUPT_COUNT = (byte)48;
    protected final byte FPGA_SINGLE_STROBE_HIGH = (byte)56;
    protected final byte FPGA_SINGLE_STROBE_LOW = (byte)60;
    protected final byte FPGA_STROBE_ENABLE = (byte)64;
    protected final byte FPGA_GPIO_MUX = (byte)72;
    protected final byte FPGA_GPIO_ENABLE = (byte)80;
    protected final byte FPGA_GPIO_DATA_REG = (byte)84;
    protected final byte FPGA_ADC_TRIGGER_DELAY = (byte)88;
    protected final byte[] FPGA_REGISTERS = new byte[]{0, 4, 8, 12, 16, 24, 32, 40, 44, 48, 56, 60, 64, 72, 80, 84, 88};
    protected String[] desc = new String[]{"Master Clock", "FPGA Firware Version", "Continuous Strobe", "CS Base Clock", "Integration B Clock", "Integration Clock", "Shutter Clock", "Hardware Trigger Delay", "Trigger Mode", "ADC Int Cnt", "S Strobe High", "S Strobe Low", "Strobe Enable", "GPIO Mux", "GPIO Output Enable", "GPIO Data", "ADC Trigger Delay"};
    protected final byte INPUT = 0;
    protected final byte OUTPUT = 1;
    protected final int NORMAL = 0;
    protected final int SOFTWARE = 1;
    protected final int SYNCHRONIZATION = 2;
    protected final int HARDWARE = 3;
    protected double wLFirst;
    protected double wLSecond;
    protected double wLThird;
    protected double wLIntercept;
    protected byte[] inb1;
    protected byte[] inb2;
    protected byte[] out;
    protected byte[] in;
    protected byte[] rawData;
    protected double[] accumulator;
    protected int[] intData;
    protected int deviceID;
    public int numberOfPixels;
    public int numberOfDarkPixels;
    protected int numPixelBytes = this.numberOfPixels * 2;
    protected int pipeSize = this.numberOfPixels * 2 + 1;
    public int deviceIndex = -1;
    public String firmwareVersion;
    public int firmwareVersionNumber;
    public String firmwareVersionString;
    public int deviceType;
    protected USBInterface usb;
    protected ByteRoutines byteRoutines = new ByteRoutines();
    protected Coefficients coefficients;
    public USBSpectrometerPlugIn plugIn;
    private boolean stringFirmware = false;

    public abstract int openSpectrometer(int var1);

    public abstract int getNumberOfPixels();

    protected abstract int formatData();

    public Spectrometer() {
        this.out = new byte[20];
        this.in = new byte[100];
        this.usb = new USBInterface();
    }

    protected void initialize() {
        this.out[0] = 1;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
    }

    protected void setITime(int intTime) {
        this.out[0] = 2;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(intTime));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(intTime));
        this.out[3] = this.byteRoutines.LOBYTE(this.byteRoutines.HIWORD(intTime));
        this.out[4] = this.byteRoutines.HIBYTE(this.byteRoutines.HIWORD(intTime));
        this.usb.bulkOut(this.deviceID, 0, this.out, 5);
    }

    protected void setStrobe(boolean strobe) {
        int on = !strobe ? 0 : 1;
        this.out[0] = 3;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(on));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(on));
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
    }

    protected void powerDown(boolean power) {
        int sd = !power ? 0 : 1;
        this.out[0] = 4;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(sd));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(sd));
        this.usb.bulkOut(this.deviceID, 0, this.out, 5);
    }

    protected String getInfo(int slot) {
        this.out[0] = this.OP_GETINFO;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(slot));
        String strRet = "";
        this.usb.bulkOut(this.deviceID, 0, this.out, 2);
        this.usb.bulkIn(this.deviceID, 3, this.in, 18);
        for (int i = 2; this.in[i] != 0 && this.in[i] != -1 && i < 18; ++i) {
            strRet = strRet + (char)this.in[i];
        }
        return strRet;
    }

    protected void setInfo(int slot, String str) {
        this.clearOutBuffer();
        this.out[0] = this.OP_PUTINFO;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(slot));
        try {
            byte[] bytes = str.getBytes("US-ASCII");
            for (int i = 0; i < bytes.length; ++i) {
                this.out[2 + i] = bytes[i];
            }
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Error encoding Spectrometer configuration variables");
            e.printStackTrace();
        }
        this.usb.bulkOut(this.deviceID, 0, this.out, 17);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            System.out.println("EEPROM not written. Please retry");
            e.printStackTrace();
        }
    }

    protected void setSerialNumber(String str) {
        this.clearOutBuffer();
        this.out[0] = 7;
        try {
            byte[] bytes = str.getBytes("US-ASCII");
            for (int i = 0; i < bytes.length; ++i) {
                this.out[1 + i] = bytes[i];
            }
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Error encoding Spectrometer serial number");
            e.printStackTrace();
        }
        this.usb.bulkOut(this.deviceID, 0, this.out, 16);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            System.out.println("EEPROM not written. Please retry");
            e.printStackTrace();
        }
    }

    protected String getSerialNumber() {
        this.out[0] = 8;
        String strRet = "";
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.in, 16);
        for (int i = 1; this.in[i] != 0 && i < 16; ++i) {
            strRet = strRet + (char)this.in[i];
        }
        return strRet;
    }

    protected void requestSpectrum() {
        this.out[0] = 9;
        this.out[1] = 0;
        this.usb.bulkOut(this.deviceID, 0, this.out, 2);
    }

    protected void setTrigMode(int mode) {
        this.out[0] = 10;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(mode));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(mode));
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
    }

    protected void setMasterClock(int rate) {
        if (rate <= 1000 && rate >= 8) {
            this.out[0] = this.OP_SETMCLK;
            this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(rate));
            this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(rate));
            this.usb.bulkOut(this.deviceID, 0, this.out, 3);
        } else {
            System.out.println("Invalid clock rate. Master Clock not set.");
        }
    }

    protected void setTECState(int data) {
        this.out[0] = 11;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(data));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(data));
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
    }

    protected void setGain(int data) {
        this.out[0] = 12;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(data));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(data));
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
    }

    protected void setFanState(int on) {
        this.out[0] = 13;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(on));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(on));
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
    }

    protected void stopSpectrum() {
        this.out[0] = 30;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(0));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(0));
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
    }

    protected byte[] readStatus() {
        this.out[0] = -2;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.rawData, 16);
        byte[] b = new byte[16];
        for (int i = 0; i < 16; ++i) {
            b[i] = this.in[i];
        }
        return b;
    }

    public int countPlugIns() {
        int numPlugIns = -1;
        this.out[0] = 11;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.in, 1);
        numPlugIns = this.in[0];
        return numPlugIns;
    }

    public byte[] initializePlugIns() {
        this.out[0] = 12;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.in, 7);
        return this.in;
    }

    public void detectPlugIns() {
        this.out[0] = 13;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
    }

    protected byte[] readI2C(byte address, byte numBytes) {
        byte[] i2C = new byte[numBytes];
        this.out[0] = 96;
        this.out[1] = address;
        this.out[2] = numBytes;
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
        this.usb.bulkIn(this.deviceID, 3, this.in, numBytes + 3);
        if (this.in[2] == address) {
            for (int i = 3; i < numBytes; ++i) {
                i2C[i - 3] = this.in[i];
            }
        }
        return i2C;
    }

    protected int writeI2C(byte address, byte numBytes, byte[] i2C) {
        String result = "";
        this.out[0] = 97;
        this.out[1] = address;
        this.out[2] = numBytes;
        for (int i = 3; i < numBytes; ++i) {
            this.out[i] = i2C[i];
        }
        this.usb.bulkOut(this.deviceID, 0, this.out, numBytes + 3);
        this.usb.bulkIn(this.deviceID, 3, this.in, 1);
        switch (this.in[0]) {
            case 0: {
                result = "I2C bus idle";
                break;
            }
            case 1: {
                result = "I2C bus Sending Data";
                break;
            }
            case 2: {
                result = "I2C bus Receiving Data";
                break;
            }
            case 3: {
                result = "I2C bus Receiving first byte of string";
                break;
            }
            case 5: {
                result = "I2C bus in waiting for STOP condition";
                break;
            }
            case 6: {
                result = "I2C experienced Bit Error";
                break;
            }
            case 7: {
                result = "I2C experienced a Not Acknowledge (NAK) Condition";
                break;
            }
            case 8: {
                result = "I2C experienced successful transfer";
                break;
            }
            case 9: {
                result = "I2C bus timed out";
                break;
            }
            default: {
                result = "Error in writing to the I2C bus";
            }
        }
        return this.in[0];
    }

    protected byte[] readSPI(int numBytes) {
        byte[] spi = new byte[numBytes];
        this.out[0] = 98;
        this.out[2] = (byte)numBytes;
        this.usb.bulkOut(this.deviceID, 0, this.out, 2);
        this.usb.bulkIn(this.deviceID, 3, this.in, numBytes + 2);
        for (int i = 1; i < numBytes; ++i) {
            spi[i - 1] = this.in[i];
        }
        return spi;
    }

    protected void writeSPI(int numBytes, byte[] data) {
        this.out[0] = 99;
        this.out[1] = (byte)numBytes;
        System.arraycopy(data, 0, this.out, 2, numBytes);
        this.usb.bulkOut(this.deviceID, 0, this.out, numBytes + 2);
    }

    protected int readPSOC() {
        int value = -1;
        this.out[0] = this.OP_PSOCWRITE;
        this.out[1] = 16;
        this.out[2] = 2;
        this.out[3] = 1;
        this.out[4] = 1;
        this.usb.bulkOut(this.deviceID, 0, this.out, 5);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            System.out.println("");
            e.printStackTrace();
        }
        this.out[0] = this.OP_PSOCREAD;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.in, 2);
        value = this.byteRoutines.MAKEWORD(this.in[0], this.in[1]);
        return value;
    }

    protected String readPSOCVersion() {
        String version = "invalid";
        this.out[0] = this.OP_PSOCWRITE;
        this.out[1] = 16;
        this.out[2] = 2;
        this.out[3] = 1;
        this.out[4] = 3;
        this.usb.bulkOut(this.deviceID, 0, this.out, 5);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            System.out.println("");
            e.printStackTrace();
        }
        this.out[0] = this.OP_PSOCREAD;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.in, 2);
        version = Integer.toHexString(this.in[0]) + Integer.toHexString(this.in[1]);
        version = version.length() == 4 ? version.substring(0, 1) + "." + version.substring(1, 3) + "." + version.substring(3) : "0.00.0";
        return version;
    }

    protected void writePSOC(int data) {
        this.out[0] = this.OP_PSOCWRITE;
        this.out[1] = 16;
        this.out[2] = 2;
        this.out[3] = 3;
        this.out[4] = 2;
        this.out[5] = this.byteRoutines.HIBYTE((short)data);
        this.out[6] = this.byteRoutines.LOBYTE((short)data);
        this.usb.bulkOut(this.deviceID, 0, this.out, 7);
    }

    protected void writeFPGA(byte reg, int value) {
        this.out[0] = 106;
        this.out[1] = reg;
        this.out[2] = this.byteRoutines.LOBYTE((short)value);
        this.out[3] = this.byteRoutines.HIBYTE((short)value);
        this.usb.bulkOut(this.deviceID, 0, this.out, 4);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.out.println("Register not written. Please retry");
        }
    }

    protected int readFPGA(byte reg) {
        short filler = 0;
        this.out[0] = 107;
        this.out[1] = reg;
        this.usb.bulkOut(this.deviceID, 0, this.out, 2);
        this.usb.bulkIn(this.deviceID, 3, this.in, 3);
        return this.byteRoutines.MAKEDWORD(filler, this.byteRoutines.MAKEWORD(this.in[2], this.in[1]));
    }

    protected int[] readAllFPGA() {
        int[] value = new int[this.FPGA_REGISTERS.length];
        short filler = 0;
        for (int i = 0; i < this.FPGA_REGISTERS.length; ++i) {
            this.out[0] = 107;
            this.out[1] = this.FPGA_REGISTERS[i];
            this.usb.bulkOut(this.deviceID, 0, this.out, 2);
            this.usb.bulkIn(this.deviceID, 3, this.in, 3);
            value[i] = this.byteRoutines.MAKEDWORD(filler, this.byteRoutines.MAKEWORD(this.in[2], this.in[1]));
        }
        return value;
    }

    protected double readTemp() {
        double value = -1.0;
        this.out[0] = 108;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.in, 3);
        if (this.in[0] == 8) {
            value = this.byteRoutines.MAKEWORD(this.in[2], this.in[1]);
            value *= 0.003906;
        } else {
            System.out.println("Error communicating with spectrometer");
        }
        return value;
    }

    protected byte[] readIRFactors(byte address) {
        this.out[0] = 109;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(address));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(address));
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
        this.usb.bulkIn(this.deviceID, 3, this.in, 60);
        return this.in;
    }

    protected void writeIRFactors(byte address, byte[] data) {
        byte[] temp = new byte[63];
        if (data.length != 60) {
            for (int i = temp.length; i > 2; --i) {
                temp[i] = 0;
            }
        }
        temp[0] = 110;
        temp[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(address));
        temp[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(address));
        System.arraycopy(data, 0, temp, 3, data.length);
        this.usb.bulkOut(this.deviceID, 0, temp, 63);
    }

    protected void readSpectrum(byte[] data) {
        this.usb.bulkIn(this.deviceID, 1, this.rawData, this.numberOfPixels * 2 + 1);
        if (data != null) {
            System.arraycopy(this.rawData, 0, data, 0, this.numberOfPixels * 2 + 1);
        }
    }

    protected Coefficients readCoefficients() {
        String[] str = new String[17];
        int i = 0;
        while (true) {
            if (i >= 17) break;
            str[i] = this.getInfo(i);
            if (str[i] == "" || str[i] == null) {
                str[i] = "0";
            }
            ++i;
        }
        this.coefficients.serialNumber = str[0];
        this.coefficients.wLIntercept = Double.parseDouble(str[1]);
        this.coefficients.wLFirst = Double.parseDouble(str[2]);
        this.coefficients.wLSecond = Double.parseDouble(str[3]);
        this.coefficients.wLThird = Double.parseDouble(str[4]);
        this.coefficients.strayLightCoef = Double.parseDouble(str[5]);
        this.coefficients.nL0 = Double.parseDouble(str[6]);
        this.coefficients.nL1 = Double.parseDouble(str[7]);
        this.coefficients.nL2 = Double.parseDouble(str[8]);
        this.coefficients.nL3 = Double.parseDouble(str[9]);
        this.coefficients.nL4 = Double.parseDouble(str[10]);
        this.coefficients.nL5 = Double.parseDouble(str[11]);
        this.coefficients.nL6 = Double.parseDouble(str[12]);
        this.coefficients.nL7 = Double.parseDouble(str[13]);
        this.coefficients.nLOrder = Integer.parseInt(str[14]);
        this.coefficients.config1 = str[15];
        this.coefficients.config2 = str[16];
        return this.coefficients;
    }

    protected void saveCoefficients(Coefficients coef) {
        String[] str = new String[17];
        str[0] = coef.serialNumber;
        str[1] = String.valueOf(coef.wLIntercept);
        str[2] = String.valueOf(coef.wLFirst);
        str[3] = String.valueOf(coef.wLSecond);
        str[4] = String.valueOf(coef.wLThird);
        str[5] = String.valueOf(coef.strayLightCoef);
        str[6] = String.valueOf(coef.nL0);
        str[7] = String.valueOf(coef.nL1);
        str[8] = String.valueOf(coef.nL2);
        str[9] = String.valueOf(coef.nL3);
        str[10] = String.valueOf(coef.nL4);
        str[11] = String.valueOf(coef.nL5);
        str[12] = String.valueOf(coef.nL6);
        str[13] = String.valueOf(coef.nL7);
        str[14] = String.valueOf(coef.nLOrder);
        str[15] = coef.config1;
        str[16] = coef.config2;
        int i = 0;
        while (true) {
            if (i >= 17) break;
            this.setInfo(i, str[i]);
            ++i;
        }
    }

    protected void closeSpectrometerDevice() {
        if (this.deviceIndex >= 0 && this.deviceID >= 0) {
            this.usb.closeDevice(this.deviceID);
            this.deviceIndex = -1;
        }
    }

    public USBSpectrometerInfo[] identifyAllOOIDevices() {
        USBSpectrometerInfo[] usi = new USBSpectrometerInfo[64];
        int index = 0;
        for (int type = 0; type < DEVICE_TYPES.length; ++type) {
            for (int i = 0; i < 64; ++i) {
                int dev = this.usb.openDevice(9303, DEVICE_TYPES[type], i);
                if (dev > 0) {
                    usi[index] = new USBSpectrometerInfo();
                    usi[index].spectrometerType = DEVICE_TYPES[type];
                    usi[index].deviceID = dev;
                    usi[index].deviceIndex = i;
                    this.usb.closeDevice(dev);
                    ++index;
                    continue;
                }
                System.out.println("Error communicating with spectrometer");
            }
        }
        USBSpectrometerInfo[] retUSI = new USBSpectrometerInfo[index];
        for (int i = 0; i < index; ++i) {
            retUSI[i] = usi[i];
            retUSI[i] = usi[i];
        }
        return retUSI;
    }

    protected String getFirmwareVersion() {
        this.firmwareVersion = this.usb.getUSBStringDescriptor(this.deviceID, 1);
        this.parseFirmwareVersion(this.firmwareVersion);
        return this.firmwareVersion;
    }

    protected void parseFirmwareVersion(String fw) {
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        String v4 = null;
        String temp = fw.substring(this.firmwareVersion.indexOf(" ") + 1).trim();
        String[] strArr = temp.split("[.]", 3);
        if (strArr.length == 3) {
            v1 = Integer.parseInt(strArr[0]);
            v2 = Integer.parseInt(strArr[1]);
            for (int i = 0; i < strArr[2].length(); ++i) {
                try {
                    v3 += Integer.parseInt(strArr[2].substring(i, i));
                    continue;
                }
                catch (NumberFormatException ne) {
                    v4 = v4 + strArr[2].substring(i, i);
                    this.stringFirmware = true;
                }
            }
        }
        if (!this.stringFirmware) {
            this.firmwareVersionNumber = this.makeVersion(v1, v2, v3);
        } else {
            this.firmwareVersionString = this.makeVersion(v1, v2, v3, v4);
            this.firmwareVersionNumber = this.makeVersion(v1, v2, v3);
        }
    }

    protected int makeVersion(int v1, int v2, int v3) {
        return v1 * 1000000 + v2 * 1000 + v3;
    }

    protected String makeVersion(int v1, int v2, int v3, String v4) {
        String version = String.valueOf(v1 * 1000000 + v2 * 1000 + v3) + v4;
        return version;
    }

    protected int getFirmwareVersionNumber() {
        return this.firmwareVersionNumber;
    }

    protected String getFirmwareVersionString() {
        return this.firmwareVersionString;
    }

    public String getStringDescriptor(int num) {
        return this.usb.getUSBStringDescriptor(this.deviceID, num);
    }

    protected void clearAccumulator() {
        for (int i = 0; i < this.numberOfPixels; ++i) {
            this.accumulator[i] = 0.0;
        }
    }

    protected void accumulateSpectrum() {
        for (int i = 0; i < this.numberOfPixels; ++i) {
            int n = i;
            this.accumulator[n] = this.accumulator[n] + (double)this.intData[i];
        }
    }

    protected void divideAccumulator(int numAverages) {
        if (numAverages != 1) {
            int i = 0;
            while (i < this.numberOfPixels) {
                int n = i++;
                this.accumulator[n] = this.accumulator[n] / (double)numAverages;
            }
        }
    }

    protected void scanWithAverage(int numAverages) {
        if (numAverages < 1) {
            numAverages = 1;
        }
        this.clearAccumulator();
        for (int i = 0; i < numAverages; ++i) {
            this.requestSpectrum();
            this.readSpectrum(null);
            this.formatData();
            this.accumulateSpectrum();
            this.doEvent(-1048576, "USBBaseSpec");
        }
        this.divideAccumulator(numAverages);
        this.doEvent(-983040, "USBBaseSpec");
    }

    protected double getWavelength(int pixel) {
        double dp = pixel;
        return this.wLIntercept + dp * this.wLFirst + dp * dp * this.wLSecond + dp * dp * dp * this.wLThird;
    }

    protected int getPixel(double wl) {
        int i;
        for (i = 0; this.getWavelength(i) < wl && i < this.numberOfPixels; ++i) {
        }
        return i;
    }

    protected void setWavelengthCoefficients(int channel, double intercept, double first, double second, double third) {
        try {
            this.wLIntercept = intercept;
            this.wLFirst = first;
            this.wLSecond = second;
            this.wLThird = third;
        }
        catch (Exception e) {
            System.out.println("Error setting the wavelength coefficients");
            e.printStackTrace();
        }
    }

    protected void setWavelengthCoefficients(double intercept, double first, double second, double third) {
        this.wLIntercept = intercept;
        this.wLFirst = first;
        this.wLSecond = second;
        this.wLThird = third;
    }

    protected String getDeviceString(int device) {
        String str;
        switch (device) {
            case 4098: {
                str = "USB2000";
                break;
            }
            case 4100: {
                str = "ADC1000-USB";
                break;
            }
            case 4102: {
                str = "SAS";
                break;
            }
            case 4106: {
                str = "HR2000";
                break;
            }
            case 4108: {
                str = "NIR512";
                break;
            }
            case 4112: {
                str = "NIR256";
                break;
            }
            case 4114: {
                str = "HR4000";
                break;
            }
            case 65280: {
                str = "No ADC";
                break;
            }
            case 4116: {
                str = "USB650";
                break;
            }
            default: {
                str = "Unknown";
            }
        }
        return str;
    }

    protected int setData(byte[] data, int length) {
        return this.usb.bulkOut(this.deviceID, 0, data, length);
    }

    protected int setData(int pipe, byte[] data, int length) {
        return this.usb.bulkOut(this.deviceID, pipe, data, length);
    }

    protected int getData(byte[] data, int length) {
        return this.usb.bulkIn(this.deviceID, 3, data, length);
    }

    protected int getData(int pipe, byte[] data, int length) {
        return this.usb.bulkIn(this.deviceID, pipe, data, length);
    }

    protected void clearInBuffer() {
        for (int i = 0; i < this.in.length; ++i) {
            this.in[i] = 0;
        }
    }

    protected void clearOutBuffer() {
        for (int i = 0; i < this.out.length; ++i) {
            this.out[i] = 0;
        }
    }

    protected void setFanQE(boolean fan) {
        int on = !fan ? 0 : 1;
        this.out[0] = this.OP_FANENABLE;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(on));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(on));
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
    }

    protected void setTECQE(boolean tec) {
        int on = !tec ? 0 : 1;
        this.out[0] = this.OP_TECENABLE;
        this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(on));
        this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(on));
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
    }

    protected double readMainBoardTemp() {
        double value = -1.0;
        this.out[0] = 108;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.in, 6);
        if (this.in[0] == 8) {
            value = this.byteRoutines.MAKEWORD(this.in[2], this.in[1]);
            value *= 0.003906;
        } else {
            System.out.println("Error communicating with spectrometer");
        }
        return value;
    }

    protected double readDetectorBoardTemp() {
        double value = -1.0;
        this.out[0] = 108;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.in, 6);
        if (this.in[3] == 8) {
            value = this.byteRoutines.MAKEWORD(this.in[5], this.in[4]);
            value *= 0.003906;
        } else {
            System.out.println("Error communicating with spectrometer - " + this.in[3]);
        }
        return value;
    }

    protected void writeTECSetPoint(double temp) {
        short value = (short)(temp * 10.0);
        this.out[0] = this.OP_TECSETTEMP;
        this.out[1] = this.byteRoutines.LOBYTE(value);
        this.out[2] = this.byteRoutines.HIBYTE(value);
        this.usb.bulkOut(this.deviceID, 0, this.out, 3);
    }

    protected double readTECTemperature() {
        double value = -1.0;
        this.out[0] = this.OP_TECREAD;
        this.usb.bulkOut(this.deviceID, 0, this.out, 1);
        this.usb.bulkIn(this.deviceID, 3, this.in, 2);
        value = this.byteRoutines.MAKEWORD(this.in[1], this.in[0]);
        return value /= 10.0;
    }
}

