/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.joedriver.usb650;

import com.oceanoptics.joedriver.spectrometer.Coefficients;
import com.oceanoptics.joedriver.spectrometer.Spectrometer;
import com.oceanoptics.joedriver.usb2000.USB2000;
import com.oceanoptics.miscroutines.DoubleArrayManipulation;
import com.oceanoptics.spectralprocessing.NumericalMethods;

public class USB650
extends Spectrometer {
    private USB2000 spec;
    public Coefficients coefficients = new Coefficients();
    public double actualWLIntercept;
    public double actualWLFirst;
    public double actualWLSecond;
    public double actualWLThird;
    private double[] actualWavelength = new double[2048];
    private double[] actualIntensity = new double[2048];
    private double[] interpolatedWavelength = new double[651];
    private double[] interpolatedIntensity = new double[651];
    private double[] fineWavelength = new double[6521];
    private double[] fineIntensity = new double[6521];
    private NumericalMethods nm = new NumericalMethods();

    public int openSpectrometer(int index) {
        int i;
        this.spec = new USB2000();
        this.numberOfPixels = 651;
        this.numberOfDarkPixels = 0;
        this.rawData = new byte[4097];
        this.intData = new int[4097];
        this.accumulator = new double[this.numberOfPixels];
        this.deviceID = this.usb.openDevice(9303, 4116, index);
        if (this.deviceID <= 0) {
            this.deviceType = -1;
            return this.deviceType;
        }
        this.deviceType = 4116;
        this.deviceIndex = index;
        this.initialize();
        this.coefficients = new Coefficients();
        this.getCoefficients();
        this.setWavelengthCoefficients(this.actualWLIntercept, this.actualWLFirst, this.actualWLSecond, this.actualWLThird);
        for (i = 0; i < 2048; ++i) {
            this.actualWavelength[i] = this.getWavelength(i);
        }
        this.setWavelengthCoefficients(this.coefficients.wLIntercept, this.coefficients.wLFirst, this.coefficients.wLSecond, this.coefficients.wLThird);
        for (i = 0; i < 651; ++i) {
            this.interpolatedWavelength[i] = this.getWavelength(i);
        }
        for (i = 0; i < 6521; ++i) {
            this.fineWavelength[i] = 349.0 + (double)i * 0.1;
        }
        return this.deviceID;
    }

    public void readSpectrum(byte[] data) {
        this.usb.bulkIn(this.deviceID, 1, this.rawData, 4097);
        if (data != null) {
            System.arraycopy(this.rawData, 0, data, 0, this.numberOfPixels * 2 + 1);
        }
    }

    public void accumulateSpectrum() {
        int i;
        for (int i2 = 0; i2 < 2048; ++i2) {
            this.actualIntensity[i2] = this.intData[i2];
        }
        DoubleArrayManipulation dam = new DoubleArrayManipulation();
        int[] elems = new int[]{30, 58, 100, 256, 74, 1023, 1835, 2001};
        dam.removeElements(this.actualIntensity, elems);
        this.fineIntensity = this.nm.cubicSpline(this.actualWavelength, this.actualIntensity, this.fineWavelength);
        for (i = 0; i < this.numberOfPixels; ++i) {
            this.interpolatedIntensity[i] = this.nm.average(this.actualWavelength, this.actualIntensity, this.interpolatedWavelength[i] - 0.5, this.interpolatedWavelength[i] + 0.499);
        }
        for (i = 0; i < this.numberOfPixels; ++i) {
            int n = i;
            this.accumulator[n] = this.accumulator[n] + this.interpolatedIntensity[i];
        }
    }

    public int formatData() {
        for (int i = 0; i < 2048; ++i) {
            int LSBPacket = i / 64;
            int MSBPacket = LSBPacket + 1;
            byte LSB = this.rawData[LSBPacket * 64 + i];
            byte MSB = this.rawData[MSBPacket * 64 + i];
            this.intData[i] = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, MSB, LSB);
        }
        if (this.rawData[4096] != 105) {
            System.out.println("Out of sync");
            return 0;
        }
        return 1;
    }

    public void getCoefficients() {
        this.coefficients = this.readCoefficients();
    }

    public int getNumberOfPixels() {
        return this.numberOfPixels;
    }
}

