/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.spectralprocessing;

public class SpectralData {
    final int MAXSPECS = 8;
    public static final int MODESCOPE = 0;
    public static final int MODEABSORBANCE = 1;
    public static final int MODETRANSMISSION = 2;
    public static final int MODEIRRADIANCE = 3;
    public static final int MODEREFLECTION = 4;
    public static final int MODESCOPEMINUSDARK = 5;
    public final String[] Y_AXIS_LABELS = new String[]{"Counts", "Absorbance", "Percent Transmission", "Relative Irradiance", "Percent Reflection", "Counts"};
    public final int[] PROCESSED_MODES = new int[]{0, 1, 2, 3, 4, 5};
    protected double[][] Dark = new double[8][];
    protected double[][] Reference = new double[8][];
    protected double[][] Sample = new double[8][];
    protected double[][] SampleDark = new double[8][];
    protected double[][] Processed = new double[8][];
    protected double[][] IrradConvArray = new double[8][];
    protected double[][] Wavelength = new double[8][];
    protected boolean[] DarkStored = new boolean[8];
    protected boolean[] ReferenceStored = new boolean[8];
    protected boolean[] SampleDarkStored = new boolean[8];
    protected boolean[] WavelengthStored = new boolean[8];
    protected int NumSpecs;
    protected int NumPixels;
    protected int ProcessingMode = 0;
    protected double ReferenceColorTemperature;

    public SpectralData(int numspecs, int numpixels) {
        this.NumSpecs = numspecs;
        this.NumPixels = numpixels;
        this.ProcessingMode = 0;
        this.ReferenceColorTemperature = 3100.0;
        for (int i = 0; i < this.NumSpecs; ++i) {
            this.Dark[i] = new double[this.NumPixels];
            this.Reference[i] = new double[this.NumPixels];
            this.Sample[i] = new double[this.NumPixels];
            this.SampleDark[i] = new double[this.NumPixels];
            this.Processed[i] = new double[this.NumPixels];
            this.Wavelength[i] = new double[this.NumPixels];
            this.IrradConvArray[i] = new double[this.NumPixels];
            this.DarkStored[i] = false;
            this.ReferenceStored[i] = false;
            this.SampleDarkStored[i] = false;
            this.WavelengthStored[i] = false;
        }
    }

    public void setDark(int chan, double[] src) {
        try {
            System.arraycopy(src, 0, this.Dark[chan], 0, src.length);
            this.DarkStored[chan] = true;
        }
        catch (Exception e) {
            System.out.println("error setting dark");
        }
    }

    public double[] getDark(int chan) {
        try {
            return this.Dark[chan];
        }
        catch (Exception e) {
            System.out.println("error getting dark");
            return null;
        }
    }

    public void setReference(int chan, double[] src) {
        try {
            System.arraycopy(src, 0, this.Reference[chan], 0, src.length);
            this.ReferenceStored[chan] = true;
        }
        catch (Exception e) {
            System.out.println("error setting reference");
        }
    }

    public double[] getReference(int chan) {
        try {
            return this.Reference[chan];
        }
        catch (Exception e) {
            System.out.println("error getting dark");
            return null;
        }
    }

    public void setSample(int chan, double[] src) {
        try {
            System.arraycopy(src, 0, this.Sample[chan], 0, src.length);
        }
        catch (Exception e) {
            System.out.println("error setting sample");
        }
    }

    public double[] getSample(int chan) {
        try {
            return this.Sample[chan];
        }
        catch (Exception e) {
            System.out.println("error getting dark");
            return null;
        }
    }

    public void setSampleDark(int chan, double[] src) {
        try {
            System.arraycopy(src, 0, this.SampleDark[chan], 0, src.length);
            this.SampleDarkStored[chan] = true;
        }
        catch (Exception e) {
            System.out.println("error setting sample dark");
        }
    }

    public double[] getSampleDark(int chan) {
        try {
            return this.SampleDark[chan];
        }
        catch (Exception e) {
            System.out.println("error getting dark");
            return null;
        }
    }

    public void setProcessed(int chan, double[] src) {
        try {
            System.arraycopy(src, 0, this.Processed[chan], 0, src.length);
        }
        catch (Exception e) {
            System.out.println("error setting processed");
        }
    }

    public double[] getProcessed(int chan) {
        try {
            return this.Processed[chan];
        }
        catch (Exception e) {
            System.out.println("error getting dark");
            return null;
        }
    }

    public void setWavelength(int chan, double[] src) {
        try {
            System.arraycopy(src, 0, this.Wavelength[chan], 0, src.length);
            this.calculateIrradConvArray(chan);
        }
        catch (Exception e) {
            System.out.println("error setting processed");
        }
    }

    public double[] getWavelength(int chan) {
        try {
            return this.Wavelength[chan];
        }
        catch (Exception e) {
            System.out.println("error getting dark");
            return null;
        }
    }

    public void setIrradConvArray(int chan, double[] src) {
        try {
            System.arraycopy(src, 0, this.IrradConvArray[chan], 0, src.length);
        }
        catch (Exception e) {
            System.out.println("error setting processed");
        }
    }

    public double[] getIrradConvArray(int chan) {
        try {
            return this.IrradConvArray[chan];
        }
        catch (Exception e) {
            System.out.println("error getting dark");
            return null;
        }
    }

    public void setProcessingMode(int m) {
        this.ProcessingMode = m;
    }

    public int getProcessingMode() {
        return this.ProcessingMode;
    }

    public void setReferenceColorTemperature(double ct) {
        this.ReferenceColorTemperature = ct;
        this.calculateIrradConvArray();
    }

    public double getReferenceColorTemperature() {
        return this.ReferenceColorTemperature;
    }

    public boolean[] getProcessedModesAvailable() {
        int chan;
        boolean[] b = new boolean[this.PROCESSED_MODES.length];
        b[0] = true;
        boolean temp = true;
        for (chan = 0; chan < this.NumSpecs; ++chan) {
            temp &= this.DarkStored[chan];
        }
        b[5] = temp;
        temp = true;
        for (chan = 0; chan < this.NumSpecs; ++chan) {
            temp &= this.DarkStored[chan] & this.ReferenceStored[chan];
        }
        b[1] = temp;
        b[2] = temp;
        b[3] = temp;
        b[4] = temp;
        return b;
    }

    public String getYAxisLabel() {
        return this.Y_AXIS_LABELS[this.ProcessingMode];
    }

    public void processSpectra() {
        try {
            switch (this.ProcessingMode) {
                case 0: {
                    for (int chan = 0; chan < this.NumSpecs; ++chan) {
                        for (int i = 0; i < this.NumPixels; ++i) {
                            this.Processed[chan][i] = this.Sample[chan][i];
                        }
                    }
                    break;
                }
                case 5: {
                    for (int chan = 0; chan < this.NumSpecs; ++chan) {
                        for (int i = 0; i < this.NumPixels; ++i) {
                            this.Processed[chan][i] = this.Sample[chan][i] - this.Dark[chan][i];
                        }
                    }
                    break;
                }
                case 1: {
                    double ln10 = Math.log(10.0);
                    for (int chan = 0; chan < this.NumSpecs; ++chan) {
                        for (int i = 0; i < this.NumPixels; ++i) {
                            double numer = this.Sample[chan][i] - this.Dark[chan][i];
                            double denom = this.Reference[chan][i] - this.Dark[chan][i];
                            this.Processed[chan][i] = numer <= 0.0 || denom <= 0.0 ? 0.0 : -Math.log(numer / denom) / ln10;
                        }
                    }
                    break;
                }
                case 2: 
                case 4: {
                    for (int chan = 0; chan < this.NumSpecs; ++chan) {
                        for (int i = 0; i < this.NumPixels; ++i) {
                            double numer = this.Sample[chan][i] - this.Dark[chan][i];
                            double denom = this.Reference[chan][i] - this.Dark[chan][i];
                            this.Processed[chan][i] = denom <= 0.0 ? 0.0 : numer / denom * 100.0;
                        }
                    }
                    break;
                }
                case 3: {
                    for (int chan = 0; chan < this.NumSpecs; ++chan) {
                        for (int i = 0; i < this.NumPixels; ++i) {
                            double numer = this.Sample[chan][i] - this.Dark[chan][i];
                            double denom = this.Reference[chan][i] - this.Dark[chan][i];
                            this.Processed[chan][i] = denom <= 0.0 ? 0.0 : numer / denom * this.IrradConvArray[chan][i];
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception processing spectra");
        }
    }

    protected void calculateIrradConvArray(int chan) {
        for (int i = 0; i < this.NumPixels; ++i) {
            double wl = this.Wavelength[chan][i] / 1000.0;
            double z1 = 37405.0 / (Math.pow(wl, 5.0) * (Math.exp(14388.0 / (wl * this.ReferenceColorTemperature)) - 1.0));
            double z2 = 1.288E-15 * Math.pow(this.ReferenceColorTemperature, 5.0);
            this.IrradConvArray[chan][i] = z1 / z2;
        }
    }

    protected void calculateIrradConvArray() {
        for (int chan = 0; chan < this.NumSpecs; ++chan) {
            this.WavelengthStored[chan] = true;
            if (!true) continue;
            this.calculateIrradConvArray(chan);
        }
    }

    public boolean getDarkStored(int chan) {
        return this.DarkStored[chan];
    }

    public boolean getReferenceStored(int chan) {
        return this.ReferenceStored[chan];
    }

    public boolean getSampleDarkStored(int chan) {
        return this.SampleDarkStored[chan];
    }

    public int getNumberOfPixels() {
        return this.NumPixels;
    }
}

