/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.joedriver.hr4000;

import com.oceanoptics.joedriver.hr4000.HR4000Status;
import com.oceanoptics.joedriver.spectrometer.Coefficients;
import com.oceanoptics.joedriver.spectrometer.Spectrometer;

public class HR4000
extends Spectrometer {
    private final int PIPE_SPECTRUM_1 = 1;
    private final int PIPE_SPECTRUM_2 = 2;
    int PIPE_SIZE_1 = 2048;
    int PIPE_SIZE_2 = 5633;
    private byte[] inb1 = new byte[this.PIPE_SIZE_1];
    private byte[] inb2 = new byte[this.PIPE_SIZE_2];

    public int openSpectrometer(int index) {
        this.numberOfPixels = 3840;
        this.numberOfDarkPixels = 13;
        this.rawData = new byte[this.PIPE_SIZE_1 + this.PIPE_SIZE_2];
        this.intData = new int[this.PIPE_SIZE_1 + this.PIPE_SIZE_2];
        this.accumulator = new double[this.numberOfPixels];
        this.coefficients = new Coefficients();
        this.deviceID = this.usb.openDevice(9303, 4114, index);
        if (this.deviceID <= 0) {
            this.deviceType = -1;
            return this.deviceType;
        }
        this.deviceType = 4114;
        this.deviceIndex = index;
        this.initialize();
        this.getFirmwareVersion();
        this.getCoefficients();
        this.setWavelengthCoefficients(this.wLIntercept, this.wLFirst, this.wLSecond, this.wLThird);
        return this.deviceID;
    }

    public void readSpectrum(byte[] data) {
        int ps = this.usb.getPacketSize(2);
        if (ps == 64) {
            this.readData(1, this.rawData, this.PIPE_SIZE_1 + this.PIPE_SIZE_2);
        } else {
            this.readData(2, this.inb1, this.PIPE_SIZE_1);
            this.readData(1, this.inb2, this.PIPE_SIZE_2);
            System.arraycopy(this.inb1, 0, this.rawData, 0, this.PIPE_SIZE_1);
            System.arraycopy(this.inb2, 0, this.rawData, this.PIPE_SIZE_1, this.PIPE_SIZE_2);
        }
        if (data != null) {
            System.arraycopy(this.rawData, 0, data, 0, this.PIPE_SIZE_1 + this.PIPE_SIZE_2);
        }
    }

    protected void scanWithAverage(int numAverages) {
        if (numAverages < 0) {
            numAverages = 1;
        }
        this.clearAccumulator();
        for (int i = 0; i < numAverages; ++i) {
            this.requestSpectrum();
            this.readSpectrum(null);
            this.formatData();
            this.accumulateSpectrum();
            this.doEvent(-1048576, "USBBaseSpec");
        }
        this.divideAccumulator(numAverages);
        this.doEvent(-983040, "USBBaseSpec");
    }

    public int formatData() {
        for (int i = 0; i < this.numberOfPixels; ++i) {
            byte LSB = this.rawData[i * 2];
            byte MSB = this.rawData[i * 2 + 1];
            this.intData[i] = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, MSB, LSB) ^ 0x2000;
        }
        if (this.rawData[this.numberOfPixels * 2] != 105) {
            System.out.println("Out of sync");
            return 0;
        }
        return 1;
    }

    public String getFWVersion() {
        return this.firmwareVersion;
    }

    public int readData(int pipe, byte[] data, int length) {
        return this.getData(pipe, data, length);
    }

    public int sendData(int pipe, byte[] data, int length) {
        return this.setData(pipe, data, length);
    }

    public String getSerialNumber() {
        return this.coefficients.serialNumber;
    }

    public String getCoefficient(int index) {
        return this.getInfo(index);
    }

    public void setCoefficient(int index, String value) {
        this.setInfo(index, value);
    }

    public void setIntegrationTime(int iTime) {
        this.setITime(iTime);
    }

    public void setStrobeEnable(boolean strobe) {
        this.setStrobe(strobe);
    }

    public void setPowerDown(boolean power) {
        this.powerDown(power);
    }

    public void getCoefficients() {
        this.coefficients = this.readCoefficients();
    }

    public void setCoefficients(int coefficient, String str) {
        this.saveCoefficients(this.coefficients);
    }

    public void scan(int avg) {
        this.scanWithAverage(avg);
    }

    public void setExternalTriggerMode(int mode) {
        this.setTrigMode(mode);
    }

    public HR4000Status getStatus() {
        byte[] sb = this.readStatus();
        HR4000Status stat = new HR4000Status();
        stat.numPixels = this.byteRoutines.MAKEWORD(sb[0], sb[1]);
        stat.integrationTime = this.byteRoutines.MAKEDWORD(sb[5], sb[4], sb[3], sb[2]);
        stat.lampEnabled = sb[6] != 0;
        stat.externalTriggerMode = sb[7];
        stat.lampEnabled = sb[8] != 0;
        stat.spectralPackets = sb[9];
        stat.powerDownFlag = sb[10];
        stat.packetCount = sb[11];
        if (Math.abs(sb[14]) == 128) {
            stat.usbSpeed = 480;
        } else if (Math.abs(sb[14]) == 0) {
            stat.usbSpeed = 12;
        } else {
            stat.usbSpeed = 0;
            System.out.println("Error determining USB Communication Speed.");
        }
        return stat;
    }

    public byte[] getPlugIns() {
        return this.initializePlugIns();
    }

    public int getNumPlugIns() {
        return this.countPlugIns();
    }

    public byte[] getI2C(byte address, byte numBytes) {
        return this.readI2C(address, numBytes);
    }

    public int setI2C(byte address, byte numBytes, byte[] i2C) {
        return this.writeI2C(address, numBytes, i2C);
    }

    public byte[] getSPI(int numBytes) {
        return this.readSPI(numBytes);
    }

    public void setSPI(int numBytes, byte[] data) {
        this.writeSPI(numBytes, data);
    }

    public int getPSOC() {
        return this.readPSOC();
    }

    public String getPSOCVersion() {
        return this.readPSOCVersion();
    }

    public void setPSOC(int data) {
        this.writePSOC(data);
    }

    public void setFPGA(byte reg, int value) {
        this.writeFPGA(reg, (short)value);
    }

    public int getFPGA(byte reg) {
        return this.readFPGA(reg);
    }

    public int[] getAllFPGA() {
        return this.readAllFPGA();
    }

    public double getBoardTemperature() {
        return this.readTemp();
    }

    public double[] getIrradianceCalibrationFactors(byte address) {
        return null;
    }

    public void setIRFactors(double[] data) {
    }

    public void closeSpectrometer() {
        this.closeSpectrometerDevice();
    }

    public double[] getAccumulator() {
        return this.accumulator;
    }

    public int getNumberOfPixels() {
        return this.numberOfPixels;
    }

    public double getStartingWavelength() {
        return this.getWavelength(0);
    }

    public double getEndingWavelength() {
        return this.getWavelength(this.numberOfPixels - 1);
    }

    public String getDeviceString() {
        return this.getDeviceString(this.deviceType);
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    protected int getFirmwareVersionNumber() {
        return this.firmwareVersionNumber;
    }

    protected String getFirmwareVersionString() {
        return this.firmwareVersionString;
    }

    public String getStringDescriptor(int num) {
        return super.getStringDescriptor(num);
    }

    public void setMasterClockDivisor(int value) {
        this.writeFPGA((byte)0, value);
    }

    public int getMasterClockDivisor() {
        return this.readFPGA((byte)0);
    }

    public String getFPGAFirmware() {
        int v = this.readFPGA((byte)4);
        byte lo = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(v));
        byte hi = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(v));
        String version = "0." + String.valueOf(lo) + "0." + String.valueOf(hi);
        return version;
    }

    public void setContinuousStrobeBase(int value) {
        this.writeFPGA((byte)8, value);
    }

    public int getContinuousStrobeBase() {
        return this.readFPGA((byte)8);
    }

    public void setContinuousStrobeClock(int value) {
        this.writeFPGA((byte)12, value);
    }

    public int getContinuousStrobeClock() {
        return this.readFPGA((byte)12);
    }

    public void setIntegrationTimeBaseClock(int value) {
        this.writeFPGA((byte)16, value);
    }

    public int getIntegrationTimeBaseClock() {
        return this.readFPGA((byte)16);
    }

    public void setIntegrationClockTimer(int value) {
        this.writeFPGA((byte)24, value);
    }

    public int getIntegrationClockTimer() {
        return this.readFPGA((byte)24);
    }

    public void setShutterClock(int value) {
        this.writeFPGA((byte)32, value);
    }

    public int getShutterClock() {
        return this.readFPGA((byte)32);
    }

    public void setHardwareTriggerDelay(int value) {
        this.writeFPGA((byte)40, value);
    }

    public int getHardwareTriggerDelay() {
        return this.readFPGA((byte)40);
    }

    public void setHarewareTriggerMode(int value) {
        this.writeFPGA((byte)44, value);
    }

    public int getHardwareTriggerMode() {
        return this.readFPGA((byte)44);
    }

    public void setSingleStrobeHigh(int value) {
        this.writeFPGA((byte)56, value);
    }

    public int getSingleStrobeHigh() {
        return this.readFPGA((byte)56);
    }

    public void setSingleStrobeLow(int value) {
        this.writeFPGA((byte)60, value);
    }

    public int getSingleStrobeLow() {
        return this.readFPGA((byte)60);
    }

    public void setStrobeEnable(int value) {
        this.writeFPGA((byte)64, value);
    }

    public int getStrobeEnable() {
        return this.readFPGA((byte)64);
    }

    public void setGPIOMux(int value) {
        this.writeFPGA((byte)72, this.formatGPIO(value));
    }

    public short getGPIOMux() {
        return this.formatGPIO(this.readFPGA((byte)72));
    }

    public void setGPIOMuxReg(int pin) {
        short current = this.getGPIOMux();
        int setter = current & ~this.formatPin(pin);
        this.writeFPGA((byte)72, this.formatGPIO(setter));
    }

    public void setGPIOMuxAlt(int pin) {
        short current = this.getGPIOMux();
        int setter = current | this.formatPin(pin);
        this.writeFPGA((byte)72, this.formatGPIO(setter));
    }

    public int getGPIOPinMux(int pin) {
        int mask;
        short all = this.getGPIOMux();
        if ((all & (mask = this.formatPin(pin))) >= 1) {
            return 1;
        }
        return 0;
    }

    public void setGPIOIO(int value) {
        this.writeFPGA((byte)80, this.formatGPIO(value));
    }

    public short getGPIOIO() {
        return this.formatGPIO(this.readFPGA((byte)80));
    }

    public void setGPIOPinIO(int pin, int value) {
        if (value == 1) {
            this.setGPIOPinOutput(pin);
        } else {
            this.setGPIOPinInput(pin);
        }
    }

    public void setGPIOPinOutput(int pin) {
        int mask = this.formatPin(pin);
        short current = this.getGPIOIO();
        int setter = current | mask;
        this.writeFPGA((byte)80, this.formatGPIO(setter));
    }

    public void setGPIOPinInput(int pin) {
        int mask = this.formatPin(pin);
        short current = this.getGPIOIO();
        int setter = current & ~mask;
        this.writeFPGA((byte)80, this.formatGPIO(setter));
    }

    public short getGPIOPinIO(int pin) {
        double mask = this.formatPin(pin);
        short all = this.formatGPIO(this.readFPGA((byte)80));
        if ((all & (int)mask) == 0) {
            return 0;
        }
        return 1;
    }

    public void setGPIODataReg(int value) {
        this.writeFPGA((byte)84, this.formatGPIO(value));
    }

    public short getGPIODataReg() {
        return this.formatGPIO(this.readFPGA((byte)84));
    }

    public void setGPIOPinData(int pin, int value) {
        double mask = this.formatPin(pin);
        if (this.getGPIOPinIO(pin) == 1) {
            short all = this.getGPIODataReg();
            if ((all & (int)mask) == 0) {
                if (value != 0) {
                    this.setGPIODataReg(all | (int)mask);
                }
            } else if (value == 0) {
                this.setGPIODataReg(all & ~((int)mask));
            }
        }
    }

    public short getGPIOPinData(int pin) {
        double mask = this.formatPin(pin);
        short all = this.getGPIODataReg();
        if ((all & (int)mask) >= 1) {
            return 1;
        }
        return 0;
    }

    private short formatGPIO(int gpio) {
        return (short)(gpio & 0x3FF);
    }

    private int formatPin(int pin) {
        return 1 << pin;
    }

    public void setSpectrometerChannel(short chan) {
    }
}

