/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.joedriver.nirbase;

import com.oceanoptics.joedriver.exceptions.InvalidVersionException;
import com.oceanoptics.joedriver.nirbase.NIRStatus;
import com.oceanoptics.joedriver.spectrometer.Coefficients;
import com.oceanoptics.joedriver.spectrometer.Spectrometer;

public abstract class NIRBase
extends Spectrometer {
    final byte OP_IRTE = (byte)11;
    final byte OP_HIGHGAIN = (byte)12;
    final byte OP_FANON = (byte)13;
    final byte OP_STOPSPEC = (byte)30;
    final byte OP_STATUS = (byte)-2;

    protected int formatData() {
        for (int i = 0; i < this.numberOfPixels; ++i) {
            int LSBPacket = i / 64;
            int MSBPacket = LSBPacket + 1;
            byte LSB = this.rawData[LSBPacket * 64 + i];
            byte MSB = this.rawData[MSBPacket * 64 + i];
            this.intData[i] = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, MSB, LSB) ^ 0x8000;
        }
        if (this.rawData[this.numberOfPixels * 2] != 105) {
            System.out.println("Out of sync");
            return 0;
        }
        return 1;
    }

    public Coefficients getCoefficients() {
        String[] str = new String[17];
        int i = 0;
        while (true) {
            if (i >= 17) break;
            str[i] = this.getInfo(i);
            ++i;
        }
        this.coefficients.serialNumber = str[0];
        this.coefficients.wLIntercept = Double.parseDouble(str[1]);
        this.coefficients.wLFirst = Double.parseDouble(str[2]);
        this.coefficients.wLSecond = Double.parseDouble(str[3]);
        this.coefficients.wLThird = Double.parseDouble(str[4]);
        this.coefficients.strayLightCoef = Double.parseDouble(str[5]);
        this.coefficients.nL0 = Double.parseDouble(str[6]);
        this.coefficients.nL1 = Double.parseDouble(str[7]);
        this.coefficients.nL2 = Double.parseDouble(str[8]);
        this.coefficients.nL3 = Double.parseDouble(str[9]);
        this.coefficients.nL4 = Double.parseDouble(str[10]);
        this.coefficients.nL5 = Double.parseDouble(str[11]);
        this.coefficients.nL6 = Double.parseDouble(str[12]);
        this.coefficients.nL7 = Double.parseDouble(str[13]);
        this.coefficients.nLOrder = Integer.parseInt(str[14]);
        this.coefficients.config1 = str[15];
        this.coefficients.config2 = str[16];
        return this.coefficients;
    }

    public void saveCoefficients(Coefficients coef) {
        String[] str = new String[17];
        str[0] = coef.serialNumber;
        str[1] = String.valueOf(coef.wLIntercept);
        str[2] = String.valueOf(coef.wLFirst);
        str[3] = String.valueOf(coef.wLSecond);
        str[4] = String.valueOf(coef.wLThird);
        str[5] = String.valueOf(coef.strayLightCoef);
        str[6] = String.valueOf(coef.nL0);
        str[7] = String.valueOf(coef.nL1);
        str[8] = String.valueOf(coef.nL2);
        str[9] = String.valueOf(coef.nL3);
        str[10] = String.valueOf(coef.nL4);
        str[11] = String.valueOf(coef.nL5);
        str[12] = String.valueOf(coef.nL6);
        str[13] = String.valueOf(coef.nL7);
        str[14] = String.valueOf(coef.nLOrder);
        str[15] = coef.config1;
        str[16] = coef.config2;
        int i = 0;
        while (true) {
            if (i >= 17) break;
            this.setInfo(i, str[i]);
            ++i;
        }
    }

    public int setSpectrometerChannel(int chan) {
        return 1;
    }

    public int setContinuousStrobeDelay(int delay) {
        return 1;
    }

    public void setIntegrationTime(int intTime) {
        byte[] out = new byte[5];
        out[0] = 2;
        out[1] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(intTime));
        out[2] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(intTime));
        super.setData(out, 3);
    }

    public int setTECEnabled(int on) {
        byte[] out = new byte[5];
        out[0] = 11;
        out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(on));
        out[2] = 0;
        return super.setData(out, 3);
    }

    public int setFanEnabled(int on) {
        byte[] out = new byte[5];
        out[0] = 13;
        out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(on));
        out[2] = 0;
        return super.setData(out, 3);
    }

    public int setHighGainEnabled(int on) {
        byte[] out = new byte[5];
        out[0] = 12;
        out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(on));
        out[2] = 0;
        return super.setData(out, 3);
    }

    public void stopSpectralAcquisition() {
        try {
            if (this.firmwareVersionNumber > this.makeVersion(2, 0, 0)) {
                throw new InvalidVersionException();
            }
            this.stopSpectrum();
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
    }

    public NIRStatus getStatus() {
        if (this.firmwareVersionNumber < this.makeVersion(0, 0, 0)) {
            return null;
        }
        byte[] sb = this.readStatus();
        NIRStatus stat = new NIRStatus();
        stat.numPixels = this.byteRoutines.MAKEWORD(sb[0], sb[1]);
        stat.integrationTime = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, sb[2], sb[3]);
        stat.lampEnabled = sb[4] != 0;
        stat.externalTriggerMode = sb[5];
        stat.takingScan = sb[6] != 0;
        stat.timerSwap = sb[7];
        stat.dataReady = sb[8] != 0;
        stat.failed = sb[9] != 0;
        stat.external5VActive = sb[10];
        stat.packetCount = sb[11];
        stat.highGainModeActive = sb[12];
        stat.tecActive = (byte)(sb[13] & 1);
        stat.fanActive = (byte)(sb[13] & 2);
        return stat;
    }

    public double[] getAccumulator() {
        return this.accumulator;
    }

    public int openSpectrometer(int index) {
        return 1;
    }

    public int getNumberOfPixels() {
        return this.numberOfPixels;
    }
}

