/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.joedriver.sas;

import com.oceanoptics.joedriver.sas.SASStatus;
import com.oceanoptics.joedriver.spectrometer.Coefficients;
import com.oceanoptics.joedriver.spectrometer.Spectrometer;

public class SAS
extends Spectrometer {
    public Coefficients coefficients;

    public int openSpectrometer(int index) {
        this.deviceID = this.usb.openDevice(9303, 4102, index);
        if (this.deviceID <= 0) {
            this.deviceType = -1;
            return this.deviceType;
        }
        this.deviceType = 4102;
        this.deviceIndex = index;
        this.initialize();
        SASStatus stat = this.getStatus();
        this.numberOfPixels = 2048;
        this.numberOfDarkPixels = 0;
        this.rawData = new byte[this.numberOfPixels * 2 + 1];
        this.intData = new int[this.numberOfPixels * 2 + 1];
        this.accumulator = new double[this.numberOfPixels];
        this.coefficients = new Coefficients();
        this.getFirmwareVersion();
        this.getCoefficients();
        this.setWavelengthCoefficients(this.coefficients.wLIntercept, this.coefficients.wLFirst, this.coefficients.wLSecond, this.coefficients.wLThird);
        return this.deviceID;
    }

    public int formatData() {
        for (int i = 0; i < this.numberOfPixels; ++i) {
            int lsbPacket = i / 64;
            int msbPacket = lsbPacket + 1;
            byte lsb = this.rawData[lsbPacket * 64 + i];
            byte msb = this.rawData[msbPacket * 64 + i];
            this.intData[i] = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, msb, lsb);
        }
        if (this.rawData[this.numberOfPixels * 2] != 105) {
            System.out.println("Out of sync");
            return 0;
        }
        return 1;
    }

    public SASStatus getStatus() {
        if (this.firmwareVersionNumber < this.makeVersion(0, 0, 0)) {
            return null;
        }
        byte[] sb = this.readStatus();
        SASStatus stat = new SASStatus();
        stat.numPixels = this.byteRoutines.MAKEWORD(sb[0], sb[1]);
        stat.integrationTime = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, sb[2], sb[3]);
        stat.lampEnabled = sb[4] != 0;
        stat.externalTriggerMode = sb[5];
        stat.takingScan = sb[6] != 0;
        stat.timerSwap = sb[7];
        stat.dataReady = sb[8] != 0;
        stat.failed = sb[9] != 0;
        return stat;
    }

    public void getCoefficients() {
        this.coefficients = this.readCoefficients();
    }

    public int getNumberOfPixels() {
        return this.numberOfPixels;
    }
}

