/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.joedriver.usb2000;

import com.oceanoptics.joedriver.exceptions.InvalidVersionException;
import com.oceanoptics.joedriver.plugins.USBSpectrometerPlugIn;
import com.oceanoptics.joedriver.spectrometer.Coefficients;
import com.oceanoptics.joedriver.spectrometer.Spectrometer;
import com.oceanoptics.joedriver.usb2000.USB2000Status;

public class USB2000
extends Spectrometer {
    private final byte OP_450GETTEMP = (byte)32;
    private final byte OP_450SETLEDMODE = (byte)33;
    private final byte OP_SETDAVALUE = (byte)37;
    private final byte OP_LOADINFO = (byte)38;
    private final byte OP_SAVEINFO = (byte)39;
    private final byte OP_D2SETR = (byte)64;
    private final byte OP_D2WRITEDCP = (byte)65;
    private final byte OP_D2READR = (byte)66;

    public int openSpectrometer(int index) {
        System.out.println("Opening the USB2000");
        this.numberOfPixels = 2048;
        this.numberOfDarkPixels = 24;
        this.rawData = new byte[this.numberOfPixels * 2 + 1];
        this.intData = new int[this.numberOfPixels * 2 + 1];
        this.accumulator = new double[this.numberOfPixels];
        this.coefficients = new Coefficients();
        this.deviceID = this.usb.openDevice(9303, 4098, index);
        System.out.println(this.deviceID);
        if (this.deviceID > 0) {
            this.deviceType = 4098;
            this.deviceIndex = index;
            this.initialize();
            System.out.println("USB2000 Initialized");
            System.out.println("Firmware Version: " + this.getFirmwareVersion());
            if (this.firmwareVersionNumber < this.makeVersion(2, 50, 0)) {
                this.OP_SETMCLK = (byte)13;
                if (this.firmwareVersionNumber < this.makeVersion(2, 0, 0)) {
                    this.OP_PUTINFO = (byte)36;
                    this.OP_GETINFO = (byte)35;
                }
            }
        } else {
            this.deviceType = -1;
            System.out.println("Could not detect the USB2000");
            return this.deviceType;
        }
        this.getCoefficients();
        this.setWavelengthCoefficients(this.wLIntercept, this.wLFirst, this.wLSecond, this.wLThird);
        this.plugIn = new USBSpectrometerPlugIn(this);
        return this.deviceID;
    }

    public int formatData() {
        for (int i = 0; i < this.numberOfPixels; ++i) {
            int LSBPacket = i / 64;
            int MSBPacket = LSBPacket + 1;
            byte LSB = this.rawData[LSBPacket * 64 + i];
            byte MSB = this.rawData[MSBPacket * 64 + i];
            this.intData[i] = this.byteRoutines.MAKEDWORD((byte)0, (byte)0, MSB, LSB);
        }
        if (this.rawData[this.numberOfPixels * 2] != 105) {
            System.out.println("Out of sync");
            return 0;
        }
        return 1;
    }

    public void setIntegrationTime(int iTime) {
        this.setIntegrationTime(iTime);
    }

    public void setStrobeEnable(boolean strobe) {
        this.setStrobe(strobe);
    }

    public void setPowerDown(boolean power) {
        this.powerDown(power);
    }

    public void getCoefficients() {
        this.coefficients = this.readCoefficients();
    }

    public void setCoefficients(int coefficient, String str) {
        this.saveCoefficients(this.coefficients);
    }

    public void getSpectrum() {
        this.requestSpectrum();
        this.scanWithAverage(1);
        double[] d = this.getAccumulator();
        for (int i = 0; i < d.length; ++i) {
            System.out.println(i + ":  " + d[i]);
        }
        System.out.println("");
    }

    public void setTriggerMode(int mode) {
        this.setTrigMode(mode);
    }

    public USB2000Status getStatus() {
        if (this.firmwareVersionNumber < this.makeVersion(2, 41, 0)) {
            return null;
        }
        byte[] sb = this.readStatus();
        USB2000Status stat = new USB2000Status();
        stat.numPixels = this.byteRoutines.MAKEWORD(sb[0], sb[1]);
        stat.integrationTime = this.byteRoutines.MAKEDWORD(sb[5], sb[4], sb[3], sb[2]);
        stat.lampEnabled = sb[6] != 0;
        stat.externalTriggerMode = sb[7];
        stat.lampEnabled = sb[8] != 0;
        return stat;
    }

    protected byte[] getPlugIns() {
        return this.initializePlugIns();
    }

    public int getNumPlugins() {
        return this.countPlugIns();
    }

    public void setPOTValue(int pot, int value) {
        if (this.firmwareVersionNumber > this.makeVersion(2, 40, 0)) {
            if (pot > 0 && pot < 3) {
                this.out[0] = 64;
                this.out[1] = (byte)pot;
                this.out[2] = (byte)value;
                super.setData(0, this.out, 3);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    System.out.println("");
                    e.printStackTrace();
                }
            } else {
                System.out.println("Invalid pot value.");
            }
        }
    }

    public byte[] getPOTValue() {
        byte[] values = new byte[4];
        if (this.firmwareVersionNumber > this.makeVersion(2, 40, 0)) {
            this.out[0] = 66;
            this.out[1] = 0;
            super.setData(0, this.out, 2);
            super.getData(values, 4);
        }
        return values;
    }

    public void setPowerUpPOTValues() {
        if (this.firmwareVersionNumber > this.makeVersion(2, 40, 0)) {
            this.out[0] = 65;
            this.out[1] = 1;
            this.out[2] = -128;
            super.setData(0, this.out, 3);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                System.out.println("");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLS450Temp() {
        int temp = 0;
        try {
            if (this.firmwareVersionNumber < this.makeVersion(2, 0, 0)) {
                throw new InvalidVersionException();
            }
            this.out[0] = 32;
            this.out[1] = 0;
            super.setData(0, this.out, 2);
            super.getData(this.in, 4);
            temp = this.byteRoutines.MAKEDWORD(this.in[3], this.in[2], this.in[1], this.in[0]);
            return temp;
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
        finally {
            return temp;
        }
    }

    public void setLS450LEDMode(int pulsed) {
        try {
            if (this.firmwareVersionNumber > this.makeVersion(2, 0, 0)) {
                throw new InvalidVersionException();
            }
            this.out[0] = 33;
            this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(pulsed));
            this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(pulsed));
            super.setData(0, this.out, 3);
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
    }

    public void setLS450DAValue(int daValue) {
        try {
            if (this.firmwareVersionNumber > this.makeVersion(2, 0, 0)) {
                throw new InvalidVersionException();
            }
            this.out[0] = 37;
            this.out[1] = this.byteRoutines.LOBYTE(this.byteRoutines.LOWORD(daValue));
            this.out[2] = this.byteRoutines.HIBYTE(this.byteRoutines.LOWORD(daValue));
            super.setData(0, this.out, 3);
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
    }

    public void saveLS450Info() {
        try {
            if (this.firmwareVersionNumber > this.makeVersion(2, 0, 0)) {
                throw new InvalidVersionException();
            }
            this.out[0] = 39;
            this.out[1] = 0;
            super.setData(0, this.out, 2);
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
    }

    public void stopSpectralAcquisition() {
        try {
            if (this.firmwareVersionNumber > this.makeVersion(2, 0, 0)) {
                throw new InvalidVersionException();
            }
            this.stopSpectrum();
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
    }

    public void setMClock(int freq) {
        try {
            if (this.firmwareVersionNumber > this.makeVersion(2, 50, 0)) {
                throw new InvalidVersionException();
            }
            this.setMasterClock(freq);
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getIRFactors(byte address) {
        byte[] ir = new byte[60];
        try {
            if (this.firmwareVersionNumber > this.makeVersion(2, 50, 0)) {
                throw new InvalidVersionException();
            }
            ir = this.readIRFactors(address);
            return ir;
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
        finally {
            return ir;
        }
    }

    public void setIRFactors(byte address, byte[] data) {
        try {
            if (this.firmwareVersionNumber > this.makeVersion(2, 50, 0)) {
                throw new InvalidVersionException();
            }
            this.writeIRFactors(address, data);
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSPI(int numBytes) {
        byte[] spi = new byte[numBytes];
        try {
            if (this.firmwareVersionNumber > this.makeVersion(0, 0, 0)) {
                throw new InvalidVersionException();
            }
            spi = this.readSPI(numBytes);
            return spi;
        }
        catch (InvalidVersionException e) {
            System.out.println(e.getMessage());
        }
        finally {
            return spi;
        }
    }

    public double[] getAccumulator() {
        return this.accumulator;
    }

    public int getNumberOfPixels() {
        return this.numberOfPixels;
    }
}

