/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.joedriver.usbinterface;

import com.oceanoptics.joedriver.usbinterface.USBConfigurationDescriptor;
import com.oceanoptics.joedriver.usbinterface.USBDeviceDescriptor;
import com.oceanoptics.joedriver.usbinterface.USBEndpointDescriptor;
import com.oceanoptics.joedriver.usbinterface.USBInterfaceDescriptor;
import java.io.IOException;

public class USBInterface {
    int[] packetSizes;

    native int NatUSBGetNumberOfMatchingDevices(int var1, int var2, int[] var3);

    native int NatUSBOpenDevice(int var1, int var2, int var3);

    native int NatUSBCloseDevice(int var1);

    native int NatUSBBulkIn(int var1, int var2, byte[] var3, int var4, int var5);

    native int NatUSBBulkOut(int var1, int var2, byte[] var3, int var4, int var5);

    native int NatUSBResetPipe(int var1, int var2);

    native int NatUSBAbortPipe(int var1, int var2);

    native int NatUSBGetConfigurationDescriptor(int var1, int var2, short[] var3);

    native int NatUSBGetDeviceDescriptor(int var1, short[] var2);

    native int NatUSBGetInterfaceDescriptor(int var1, byte[] var2);

    native int NatUSBGetEndpointDescriptor(int var1, int var2, short[] var3);

    native String NatUSBGetStringDescriptor(int var1, int var2);

    public int getNumberOfMatchingDevices(int vendID, int prodid, int[] devs) {
        return this.NatUSBGetNumberOfMatchingDevices(vendID, prodid, devs);
    }

    public int getPacketSize(int pack) {
        return this.packetSizes[pack];
    }

    public int openDevice(int vendID, int prodID, int number) {
        int devID = this.NatUSBOpenDevice(vendID, prodID, number);
        USBInterfaceDescriptor id = this.getUSBInterfaceDescriptor(devID);
        int numPipes = id.bNumEndpoints;
        this.packetSizes = new int[numPipes];
        for (int i = 0; i < numPipes; ++i) {
            USBEndpointDescriptor ed = this.getUSBEndpointDescriptor(devID, i);
            this.packetSizes[i] = ed.wMaxPacketSize;
        }
        return devID;
    }

    public int closeDevice(int devID) {
        return this.NatUSBCloseDevice(devID);
    }

    public int bulkIn(int devID, int pipe, byte[] data, int size) {
        return this.NatUSBBulkIn(devID, pipe, data, size, this.packetSizes[pipe]);
    }

    public int bulkOut(int devID, int pipe, byte[] data, int size) {
        return this.NatUSBBulkOut(devID, pipe, data, size, this.packetSizes[pipe]);
    }

    public void resetPipe(int devID, int pipe) throws IOException {
        int result = this.NatUSBResetPipe(devID, pipe);
        if (result == -1) {
            throw new IOException("Unknown device.");
        }
        if (result == -2) {
            throw new IOException("Reset failed.");
        }
    }

    public int abortPipe(int devID, int pipe) {
        return this.NatUSBAbortPipe(devID, pipe);
    }

    public USBConfigurationDescriptor getUSBConfigurationDescriptor(int devID, int configNum) {
        USBConfigurationDescriptor cd = new USBConfigurationDescriptor();
        short[] sa = new short[8];
        this.NatUSBGetConfigurationDescriptor(devID, configNum, sa);
        cd.bLength = (byte)sa[0];
        cd.bDescriptorType = (byte)sa[1];
        cd.wTotalLength = sa[2];
        cd.bNumInterfaces = (byte)sa[3];
        cd.bConfigurationValue = (byte)sa[4];
        cd.iConfiguration = (byte)sa[5];
        cd.bmAttributes = (byte)sa[6];
        cd.MaxPower = (byte)sa[7];
        return cd;
    }

    public USBDeviceDescriptor getUSBDeviceDescriptor(int devID) {
        USBDeviceDescriptor dd = new USBDeviceDescriptor();
        short[] sa = new short[14];
        this.NatUSBGetDeviceDescriptor(devID, sa);
        dd.bLength = (byte)sa[0];
        dd.bDescriptorType = (byte)sa[1];
        dd.bcdUSB = sa[2];
        dd.bDeviceClass = (byte)sa[3];
        dd.bDeviceSubClass = (byte)sa[4];
        dd.bDeviceProtocol = (byte)sa[5];
        dd.bMaxPacketSize0 = (byte)sa[6];
        dd.idVendor = sa[7];
        dd.idProduct = sa[8];
        dd.bcdDevice = sa[9];
        dd.iManufacturer = (byte)sa[10];
        dd.iProduct = (byte)sa[11];
        dd.iSerialNumber = (byte)sa[12];
        dd.bNumConfigurations = (byte)sa[13];
        return dd;
    }

    public USBInterfaceDescriptor getUSBInterfaceDescriptor(int devID) {
        USBInterfaceDescriptor id = new USBInterfaceDescriptor();
        byte[] ba = new byte[9];
        this.NatUSBGetInterfaceDescriptor(devID, ba);
        id.bLength = ba[0];
        id.bDescriptorType = ba[1];
        id.bInterfaceNumber = ba[2];
        id.bAlternateSetting = ba[3];
        id.bNumEndpoints = ba[4];
        id.bInterfaceClass = ba[5];
        id.bInterfaceSubClass = ba[6];
        id.bInterfaceProtocol = ba[7];
        id.iInterface = ba[8];
        return id;
    }

    public USBEndpointDescriptor getUSBEndpointDescriptor(int devID, int pipe) {
        USBEndpointDescriptor ed = new USBEndpointDescriptor();
        short[] sa = new short[6];
        this.NatUSBGetEndpointDescriptor(devID, pipe, sa);
        ed.bLength = (byte)sa[0];
        ed.bDescriptorType = (byte)sa[1];
        ed.bEndpointAddress = (byte)sa[2];
        ed.bmAttributes = (byte)sa[3];
        ed.wMaxPacketSize = sa[4];
        ed.bInterval = (byte)sa[5];
        return ed;
    }

    public String getUSBStringDescriptor(int devID, int index) {
        return this.NatUSBGetStringDescriptor(devID, index);
    }

    static {
        System.loadLibrary("NatUSB");
    }
}

