/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.spectralprocessing;

public class NumericalMethods {
    public final int INTEGRAL_RECTANGULAR = 1;
    public final int INTEGRAL_TRAPAZOID = 2;
    public final int INTEGRAL_SIMPSONS = 3;
    private int lastHuntValue = 0;

    public double average(double[] data) {
        double sumX = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sumX += data[i];
        }
        double average = sumX / (double)data.length;
        return average;
    }

    public double average(double[] in, int start, int end) {
        if (end < start) {
            int x = start;
            start = end;
            end = x;
        }
        int newLen = end - start + 1;
        double[] arr = new double[newLen];
        for (int i = 0; i < newLen; ++i) {
            arr[i] = in[start + i];
        }
        return this.average(arr);
    }

    public double average(double[] x, double[] in, double startX, double endX) {
        int startPix = this.nrHunt(x, startX);
        int endPix = this.nrHunt(x, endX);
        return this.average(in, startPix, endPix);
    }

    public double stdev(double[] data) {
        double sumX = 0.0;
        double sumX2 = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sumX += data[i];
            sumX2 += data[i] * data[i];
        }
        double n = data.length;
        double numer = sumX2 - sumX * sumX / n;
        double sdev = numer >= 0.0 ? Math.sqrt(numer / -1.0) : 0.0;
        return sdev;
    }

    public double stdev(double[] in, int start, int end) {
        if (end < start) {
            int x = start;
            start = end;
            end = x;
        }
        int newLen = end - start + 1;
        double[] arr = new double[newLen];
        for (int i = 0; i < newLen; ++i) {
            arr[i] = in[start + i];
        }
        return this.stdev(arr);
    }

    public double stdev(double[] x, double[] in, double startX, double endX) {
        int startPix = this.nrHunt(x, startX);
        int endPix = this.nrHunt(x, endX);
        return this.stdev(in, startPix, endPix);
    }

    public double integrate(double[] x, double[] y, double startX, double endX, int integraltype) {
        int startPix = this.nrHunt(x, startX);
        int endPix = this.nrHunt(x, endX);
        return this.integrate(x, y, startPix, endPix, integraltype);
    }

    public double integrate(double[] x, double[] y, int startX, int endX, int integraltype) {
        double integral = 0.0;
        switch (integraltype) {
            case 1: {
                for (int i = startX; i < endX + 1; ++i) {
                    integral += y[i] * (x[i + 1] - x[i]);
                }
                break;
            }
            case 2: {
                for (int i = startX; i < endX + 1; ++i) {
                    integral += (0.5 * y[i] + 0.5 * y[i + 1]) * (x[i + 1] - x[i]);
                }
                break;
            }
            case 3: {
                for (int i = startX; i < endX + 1; ++i) {
                    integral += (0.3333333333333333 * y[i] + 1.3333333333333333 * y[i + 1] + 0.3333333333333333 * y[i + 2]) * (x[i + 1] - x[i]);
                }
                break;
            }
        }
        return integral;
    }

    public double integrate(double[] x, double[] y, int integraltype) {
        return this.integrate(x, y, 0, x.length - 1, integraltype);
    }

    private int nrHunt(double[] x, double val) {
        int jhi;
        boolean ascnd;
        int jlo = this.lastHuntValue;
        int n = x.length - 1;
        boolean bl = ascnd = x[n] > x[1];
        if (jlo <= 0 || jlo > n) {
            jlo = 0;
            jhi = n + 1;
        } else {
            int inc = 1;
            if (val >= x[jlo] == ascnd) {
                if (jlo == n) {
                    return jlo;
                }
                jhi = jlo + 1;
                while (val >= x[jhi] == ascnd) {
                    jlo = jhi;
                    if ((jhi = jlo + (inc += inc)) <= n) continue;
                    jhi = n + 1;
                    break;
                }
            } else {
                if (jlo == 1) {
                    jlo = 0;
                    return jlo;
                }
                jhi = jlo--;
                while (val < x[jlo] == ascnd) {
                    jhi = jlo;
                    if ((inc <<= 1) >= jhi) {
                        jlo = 0;
                        break;
                    }
                    jlo = jhi - inc;
                }
            }
        }
        while (jhi - jlo != 1) {
            int jm = jhi + jlo >> 1;
            if (val > x[jm] == ascnd) {
                jlo = jm;
                continue;
            }
            jhi = jm;
        }
        return jlo;
    }

    private double[] nrSpline(double[] x, double[] y, double dx0, double dxn) {
        double qn;
        double un;
        int n = x.length - 1;
        double[] u = new double[x.length];
        double[] y2 = new double[x.length];
        if (dx0 > 9.9E29) {
            u[0] = 0.0;
            y2[0] = 0.0;
        } else {
            y2[0] = -0.5;
            u[0] = 3.0 / (x[1] - x[0]) * ((y[1] - y[0]) / (x[1] - x[0]) - dx0);
        }
        for (int i = 1; i < n - 1; ++i) {
            double sig = (x[i] - x[i - 1]) / (x[i + 1] - x[i - 1]);
            double p = sig * y2[i - 1] + 2.0;
            y2[i] = (sig - 1.0) / p;
            u[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]) - (y[i] - y[i - 1]) / (x[i] - x[i - 1]);
            u[i] = (6.0 * u[i] / (x[i + 1] - x[i - 1]) - sig * u[i - 1]) / p;
        }
        if (dxn > 9.9E29) {
            un = 0.0;
            qn = 0.0;
        } else {
            qn = 0.5;
            un = 3.0 / (x[n] - x[n - 1]) * (dxn - (y[n] - y[n - 1]) / (x[n] - x[n - 1]));
        }
        y2[n] = (un - qn * u[n - 1]) / (qn * y2[n - 1] + 1.0);
        for (int k = n - 1; k >= 1; --k) {
            y2[k] = y2[k] * y2[k + 1] + u[k];
        }
        return y2;
    }

    private double nrSplint(double[] x, double[] y, double[] dy, double xval) {
        int klo = 0;
        int khi = 0;
        boolean k = false;
        int n = x.length - 1;
        klo = this.nrHunt(x, xval);
        if (klo >= x.length - 1) {
            return y[x.length - 1];
        }
        khi = klo + 1;
        double h = x[khi] - x[klo];
        if (h == 0.0) {
            return 0.0;
        }
        double a = (x[khi] - xval) / h;
        double b = (xval - x[klo]) / h;
        double retval = a * y[klo] + b * y[khi] + ((a * a * a - a) * dy[klo] + (b * b * b - b) * dy[khi]) * (h * h) / 6.0;
        return retval;
    }

    public double[] cubicSpline(double[] xIn, double[] yIn, double[] xOut) {
        double[] yout = new double[xOut.length];
        double[] yp = this.nrSpline(xIn, yIn, 0.0, 0.0);
        for (int i = 0; i < xOut.length; ++i) {
            yout[i] = this.nrSplint(xIn, yIn, yp, xOut[i]);
        }
        return yout;
    }
}

